import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppGroupAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * App to associate group with
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#app_id AppGroupAssignment#app_id}
    */
    readonly appId: string;
    /**
    * Group associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#group_id AppGroupAssignment#group_id}
    */
    readonly groupId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#id AppGroupAssignment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#priority AppGroupAssignment#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#profile AppGroupAssignment#profile}
    */
    readonly profile?: string;
    /**
    * Retain the group assignment on destroy. If set to true, the resource will be removed from state but not from the Okta app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#retain_assignment AppGroupAssignment#retain_assignment}
    */
    readonly retainAssignment?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#timeouts AppGroupAssignment#timeouts}
    */
    readonly timeouts?: AppGroupAssignmentTimeouts;
}
export interface AppGroupAssignmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#create AppGroupAssignment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#read AppGroupAssignment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment#update AppGroupAssignment#update}
    */
    readonly update?: string;
}
export declare function appGroupAssignmentTimeoutsToTerraform(struct?: AppGroupAssignmentTimeoutsOutputReference | AppGroupAssignmentTimeouts | cdktf.IResolvable): any;
export declare class AppGroupAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppGroupAssignmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppGroupAssignmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment okta_app_group_assignment}
*/
export declare class AppGroupAssignment extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_group_assignment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_group_assignment okta_app_group_assignment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppGroupAssignmentConfig
    */
    constructor(scope: Construct, id: string, config: AppGroupAssignmentConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _retainAssignment?;
    get retainAssignment(): boolean | cdktf.IResolvable;
    set retainAssignment(value: boolean | cdktf.IResolvable);
    resetRetainAssignment(): void;
    get retainAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): AppGroupAssignmentTimeoutsOutputReference;
    putTimeouts(value: AppGroupAssignmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppGroupAssignmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
