import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppOauthConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#accessibility_error_redirect_url AppOauth#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#accessibility_login_redirect_url AppOauth#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#accessibility_self_service AppOauth#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#admin_note AppOauth#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#app_links_json AppOauth#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Application settings in JSON format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#app_settings_json AppOauth#app_settings_json}
    */
    readonly appSettingsJson?: string;
    /**
    * Id of this apps authentication policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#authentication_policy AppOauth#authentication_policy}
    */
    readonly authenticationPolicy?: string;
    /**
    * Requested key rotation mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#auto_key_rotation AppOauth#auto_key_rotation}
    */
    readonly autoKeyRotation?: boolean | cdktf.IResolvable;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#auto_submit_toolbar AppOauth#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * OAuth client secret key, this can be set when token_endpoint_auth_method is client_secret_basic.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#client_basic_secret AppOauth#client_basic_secret}
    */
    readonly clientBasicSecret?: string;
    /**
    * OAuth client ID. If set during creation, app is created with this id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#client_id AppOauth#client_id}
    */
    readonly clientId?: string;
    /**
    * URI to a web page providing information about the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#client_uri AppOauth#client_uri}
    */
    readonly clientUri?: string;
    /**
    * *Early Access Property*. Indicates whether user consent is required or implicit. Valid values: REQUIRED, TRUSTED. Default value is TRUSTED
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#consent_method AppOauth#consent_method}
    */
    readonly consentMethod?: string;
    /**
    * **Deprecated** This property allows you to set your client_id during creation. NOTE: updating after creation will be a no-op, use client_id for that behavior instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#custom_client_id AppOauth#custom_client_id}
    */
    readonly customClientId?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#enduser_note AppOauth#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * List of OAuth 2.0 grant types. Conditional validation params found here https://developer.okta.com/docs/api/resources/apps#credentials-settings-details. Defaults to minimum requirements per app type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#grant_types AppOauth#grant_types}
    */
    readonly grantTypes?: string[];
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#groups AppOauth#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#hide_ios AppOauth#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#hide_web AppOauth#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#id AppOauth#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * *Early Access Property*. Enable Federation Broker Mode.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#implicit_assignment AppOauth#implicit_assignment}
    */
    readonly implicitAssignment?: boolean | cdktf.IResolvable;
    /**
    * *Early Access Property*. Indicates whether the Okta Authorization Server uses the original Okta org domain URL or a custom domain URL as the issuer of ID token for this client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#issuer_mode AppOauth#issuer_mode}
    */
    readonly issuerMode?: string;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#label AppOauth#label}
    */
    readonly label: string;
    /**
    * The type of Idp-Initiated login that the client supports, if any
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#login_mode AppOauth#login_mode}
    */
    readonly loginMode?: string;
    /**
    * List of scopes to use for the request
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#login_scopes AppOauth#login_scopes}
    */
    readonly loginScopes?: string[];
    /**
    * URI that initiates login.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#login_uri AppOauth#login_uri}
    */
    readonly loginUri?: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#logo AppOauth#logo}
    */
    readonly logo?: string;
    /**
    * URI that references a logo for the client.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#logo_uri AppOauth#logo_uri}
    */
    readonly logoUri?: string;
    /**
    * This tells the provider not to persist the application's secret to state. If this is ever changes from true => false your app will be recreated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#omit_secret AppOauth#omit_secret}
    */
    readonly omitSecret?: boolean | cdktf.IResolvable;
    /**
    * URI to web page providing client policy document.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#policy_uri AppOauth#policy_uri}
    */
    readonly policyUri?: string;
    /**
    * List of URIs for redirection after logout. Note: see okta_app_oauth_post_logout_redirect_uri for appending to this list in a decentralized way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#post_logout_redirect_uris AppOauth#post_logout_redirect_uris}
    */
    readonly postLogoutRedirectUris?: string[];
    /**
    * Custom JSON that represents an OAuth application's profile
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#profile AppOauth#profile}
    */
    readonly profile?: string;
    /**
    * List of URIs for use in the redirect-based flow. This is required for all application types except service. Note: see okta_app_oauth_redirect_uri for appending to this list in a decentralized way.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#redirect_uris AppOauth#redirect_uris}
    */
    readonly redirectUris?: string[];
    /**
    * *Early Access Property* Grace period for token rotation
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#refresh_token_leeway AppOauth#refresh_token_leeway}
    */
    readonly refreshTokenLeeway?: number;
    /**
    * *Early Access Property* Refresh token rotation behavior
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#refresh_token_rotation AppOauth#refresh_token_rotation}
    */
    readonly refreshTokenRotation?: string;
    /**
    * List of OAuth 2.0 response type strings.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#response_types AppOauth#response_types}
    */
    readonly responseTypes?: string[];
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#skip_groups AppOauth#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#skip_users AppOauth#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#status AppOauth#status}
    */
    readonly status?: string;
    /**
    * Requested authentication method for the token endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#token_endpoint_auth_method AppOauth#token_endpoint_auth_method}
    */
    readonly tokenEndpointAuthMethod?: string;
    /**
    * URI to web page providing client tos (terms of service).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#tos_uri AppOauth#tos_uri}
    */
    readonly tosUri?: string;
    /**
    * The type of client application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#type AppOauth#type}
    */
    readonly type: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#user_name_template AppOauth#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#user_name_template_push_status AppOauth#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#user_name_template_suffix AppOauth#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#user_name_template_type AppOauth#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * *Early Access Property*. Indicates if the client is allowed to use wildcard matching of redirect_uris
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#wildcard_redirect AppOauth#wildcard_redirect}
    */
    readonly wildcardRedirect?: string;
    /**
    * groups_claim block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#groups_claim AppOauth#groups_claim}
    */
    readonly groupsClaim?: AppOauthGroupsClaim;
    /**
    * jwks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#jwks AppOauth#jwks}
    */
    readonly jwks?: AppOauthJwks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#timeouts AppOauth#timeouts}
    */
    readonly timeouts?: AppOauthTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#users AppOauth#users}
    */
    readonly users?: AppOauthUsers[] | cdktf.IResolvable;
}
export interface AppOauthGroupsClaim {
    /**
    * Groups claim filter. Can only be set if type is FILTER.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#filter_type AppOauth#filter_type}
    */
    readonly filterType?: string;
    /**
    * Name of the claim that will be used in the token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#name AppOauth#name}
    */
    readonly name: string;
    /**
    * Groups claim type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#type AppOauth#type}
    */
    readonly type: string;
    /**
    * Value of the claim. Can be an Okta Expression Language statement that evaluates at the time the token is minted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#value AppOauth#value}
    */
    readonly value: string;
}
export declare function appOauthGroupsClaimToTerraform(struct?: AppOauthGroupsClaimOutputReference | AppOauthGroupsClaim): any;
export declare class AppOauthGroupsClaimOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppOauthGroupsClaim | undefined;
    set internalValue(value: AppOauthGroupsClaim | undefined);
    private _filterType?;
    get filterType(): string;
    set filterType(value: string);
    resetFilterType(): void;
    get filterTypeInput(): string | undefined;
    get issuerMode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface AppOauthJwks {
    /**
    * RSA Exponent
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#e AppOauth#e}
    */
    readonly e?: string;
    /**
    * Key ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#kid AppOauth#kid}
    */
    readonly kid: string;
    /**
    * Key type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#kty AppOauth#kty}
    */
    readonly kty: string;
    /**
    * RSA Modulus
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#n AppOauth#n}
    */
    readonly n?: string;
}
export declare function appOauthJwksToTerraform(struct?: AppOauthJwks | cdktf.IResolvable): any;
export declare class AppOauthJwksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppOauthJwks | cdktf.IResolvable | undefined;
    set internalValue(value: AppOauthJwks | cdktf.IResolvable | undefined);
    private _e?;
    get e(): string;
    set e(value: string);
    resetE(): void;
    get eInput(): string | undefined;
    private _kid?;
    get kid(): string;
    set kid(value: string);
    get kidInput(): string | undefined;
    private _kty?;
    get kty(): string;
    set kty(value: string);
    get ktyInput(): string | undefined;
    private _n?;
    get n(): string;
    set n(value: string);
    resetN(): void;
    get nInput(): string | undefined;
}
export declare class AppOauthJwksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppOauthJwks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppOauthJwksOutputReference;
}
export interface AppOauthTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#create AppOauth#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#read AppOauth#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#update AppOauth#update}
    */
    readonly update?: string;
}
export declare function appOauthTimeoutsToTerraform(struct?: AppOauthTimeoutsOutputReference | AppOauthTimeouts | cdktf.IResolvable): any;
export declare class AppOauthTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppOauthTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppOauthTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AppOauthUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#id AppOauth#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#password AppOauth#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_oauth#username AppOauth#username}
    */
    readonly username?: string;
}
export declare function appOauthUsersToTerraform(struct?: AppOauthUsers | cdktf.IResolvable): any;
export declare class AppOauthUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppOauthUsers | cdktf.IResolvable | undefined;
    set internalValue(value: AppOauthUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class AppOauthUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppOauthUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppOauthUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_oauth okta_app_oauth}
*/
export declare class AppOauth extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_oauth";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_oauth okta_app_oauth} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppOauthConfig
    */
    constructor(scope: Construct, id: string, config: AppOauthConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    get appSettingsJson(): string;
    set appSettingsJson(value: string);
    resetAppSettingsJson(): void;
    get appSettingsJsonInput(): string | undefined;
    private _authenticationPolicy?;
    get authenticationPolicy(): string;
    set authenticationPolicy(value: string);
    resetAuthenticationPolicy(): void;
    get authenticationPolicyInput(): string | undefined;
    private _autoKeyRotation?;
    get autoKeyRotation(): boolean | cdktf.IResolvable;
    set autoKeyRotation(value: boolean | cdktf.IResolvable);
    resetAutoKeyRotation(): void;
    get autoKeyRotationInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _clientBasicSecret?;
    get clientBasicSecret(): string;
    set clientBasicSecret(value: string);
    resetClientBasicSecret(): void;
    get clientBasicSecretInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    resetClientId(): void;
    get clientIdInput(): string | undefined;
    get clientSecret(): string;
    private _clientUri?;
    get clientUri(): string;
    set clientUri(value: string);
    resetClientUri(): void;
    get clientUriInput(): string | undefined;
    private _consentMethod?;
    get consentMethod(): string;
    set consentMethod(value: string);
    resetConsentMethod(): void;
    get consentMethodInput(): string | undefined;
    private _customClientId?;
    get customClientId(): string;
    set customClientId(value: string);
    resetCustomClientId(): void;
    get customClientIdInput(): string | undefined;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    private _grantTypes?;
    get grantTypes(): string[];
    set grantTypes(value: string[]);
    resetGrantTypes(): void;
    get grantTypesInput(): string[] | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _implicitAssignment?;
    get implicitAssignment(): boolean | cdktf.IResolvable;
    set implicitAssignment(value: boolean | cdktf.IResolvable);
    resetImplicitAssignment(): void;
    get implicitAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _issuerMode?;
    get issuerMode(): string;
    set issuerMode(value: string);
    resetIssuerMode(): void;
    get issuerModeInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _loginMode?;
    get loginMode(): string;
    set loginMode(value: string);
    resetLoginMode(): void;
    get loginModeInput(): string | undefined;
    private _loginScopes?;
    get loginScopes(): string[];
    set loginScopes(value: string[]);
    resetLoginScopes(): void;
    get loginScopesInput(): string[] | undefined;
    private _loginUri?;
    get loginUri(): string;
    set loginUri(value: string);
    resetLoginUri(): void;
    get loginUriInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    private _logoUri?;
    get logoUri(): string;
    set logoUri(value: string);
    resetLogoUri(): void;
    get logoUriInput(): string | undefined;
    get logoUrl(): string;
    get name(): string;
    private _omitSecret?;
    get omitSecret(): boolean | cdktf.IResolvable;
    set omitSecret(value: boolean | cdktf.IResolvable);
    resetOmitSecret(): void;
    get omitSecretInput(): boolean | cdktf.IResolvable | undefined;
    private _policyUri?;
    get policyUri(): string;
    set policyUri(value: string);
    resetPolicyUri(): void;
    get policyUriInput(): string | undefined;
    private _postLogoutRedirectUris?;
    get postLogoutRedirectUris(): string[];
    set postLogoutRedirectUris(value: string[]);
    resetPostLogoutRedirectUris(): void;
    get postLogoutRedirectUrisInput(): string[] | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _redirectUris?;
    get redirectUris(): string[];
    set redirectUris(value: string[]);
    resetRedirectUris(): void;
    get redirectUrisInput(): string[] | undefined;
    private _refreshTokenLeeway?;
    get refreshTokenLeeway(): number;
    set refreshTokenLeeway(value: number);
    resetRefreshTokenLeeway(): void;
    get refreshTokenLeewayInput(): number | undefined;
    private _refreshTokenRotation?;
    get refreshTokenRotation(): string;
    set refreshTokenRotation(value: string);
    resetRefreshTokenRotation(): void;
    get refreshTokenRotationInput(): string | undefined;
    private _responseTypes?;
    get responseTypes(): string[];
    set responseTypes(value: string[]);
    resetResponseTypes(): void;
    get responseTypesInput(): string[] | undefined;
    get signOnMode(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _tokenEndpointAuthMethod?;
    get tokenEndpointAuthMethod(): string;
    set tokenEndpointAuthMethod(value: string);
    resetTokenEndpointAuthMethod(): void;
    get tokenEndpointAuthMethodInput(): string | undefined;
    private _tosUri?;
    get tosUri(): string;
    set tosUri(value: string);
    resetTosUri(): void;
    get tosUriInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _wildcardRedirect?;
    get wildcardRedirect(): string;
    set wildcardRedirect(value: string);
    resetWildcardRedirect(): void;
    get wildcardRedirectInput(): string | undefined;
    private _groupsClaim;
    get groupsClaim(): AppOauthGroupsClaimOutputReference;
    putGroupsClaim(value: AppOauthGroupsClaim): void;
    resetGroupsClaim(): void;
    get groupsClaimInput(): AppOauthGroupsClaim | undefined;
    private _jwks;
    get jwks(): AppOauthJwksList;
    putJwks(value: AppOauthJwks[] | cdktf.IResolvable): void;
    resetJwks(): void;
    get jwksInput(): cdktf.IResolvable | AppOauthJwks[] | undefined;
    private _timeouts;
    get timeouts(): AppOauthTimeoutsOutputReference;
    putTimeouts(value: AppOauthTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppOauthTimeouts | undefined;
    private _users;
    get users(): AppOauthUsersList;
    putUsers(value: AppOauthUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | AppOauthUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
