import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppSamlAppSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Application ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings#app_id AppSamlAppSettings#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings#id AppSamlAppSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Application settings in JSON format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings#settings AppSamlAppSettings#settings}
    */
    readonly settings: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings okta_app_saml_app_settings}
*/
export declare class AppSamlAppSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_saml_app_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_saml_app_settings okta_app_saml_app_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppSamlAppSettingsConfig
    */
    constructor(scope: Construct, id: string, config: AppSamlAppSettingsConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _settings?;
    get settings(): string;
    set settings(value: string);
    get settingsInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
