import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppSharedCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#accessibility_error_redirect_url AppSharedCredentials#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#accessibility_login_redirect_url AppSharedCredentials#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#accessibility_self_service AppSharedCredentials#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#admin_note AppSharedCredentials#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#app_links_json AppSharedCredentials#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#auto_submit_toolbar AppSharedCredentials#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * Login button field
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#button_field AppSharedCredentials#button_field}
    */
    readonly buttonField?: string;
    /**
    * CSS selector for the checkbox
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#checkbox AppSharedCredentials#checkbox}
    */
    readonly checkbox?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#enduser_note AppSharedCredentials#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#groups AppSharedCredentials#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#hide_ios AppSharedCredentials#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#hide_web AppSharedCredentials#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#id AppSharedCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#label AppSharedCredentials#label}
    */
    readonly label: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#logo AppSharedCredentials#logo}
    */
    readonly logo?: string;
    /**
    * Login password field
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#password_field AppSharedCredentials#password_field}
    */
    readonly passwordField?: string;
    /**
    * Preconfigured app name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#preconfigured_app AppSharedCredentials#preconfigured_app}
    */
    readonly preconfiguredApp?: string;
    /**
    * Secondary URL of the sign-in page for this app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#redirect_url AppSharedCredentials#redirect_url}
    */
    readonly redirectUrl?: string;
    /**
    * Shared password, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#shared_password AppSharedCredentials#shared_password}
    */
    readonly sharedPassword?: string;
    /**
    * Shared username, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#shared_username AppSharedCredentials#shared_username}
    */
    readonly sharedUsername?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#skip_groups AppSharedCredentials#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#skip_users AppSharedCredentials#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#status AppSharedCredentials#status}
    */
    readonly status?: string;
    /**
    * Login URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#url AppSharedCredentials#url}
    */
    readonly url?: string;
    /**
    * A regex that further restricts URL to the specified regex
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#url_regex AppSharedCredentials#url_regex}
    */
    readonly urlRegex?: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#user_name_template AppSharedCredentials#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#user_name_template_push_status AppSharedCredentials#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#user_name_template_suffix AppSharedCredentials#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#user_name_template_type AppSharedCredentials#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * Login username field
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#username_field AppSharedCredentials#username_field}
    */
    readonly usernameField?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#timeouts AppSharedCredentials#timeouts}
    */
    readonly timeouts?: AppSharedCredentialsTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#users AppSharedCredentials#users}
    */
    readonly users?: AppSharedCredentialsUsers[] | cdktf.IResolvable;
}
export interface AppSharedCredentialsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#create AppSharedCredentials#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#read AppSharedCredentials#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#update AppSharedCredentials#update}
    */
    readonly update?: string;
}
export declare function appSharedCredentialsTimeoutsToTerraform(struct?: AppSharedCredentialsTimeoutsOutputReference | AppSharedCredentialsTimeouts | cdktf.IResolvable): any;
export declare class AppSharedCredentialsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppSharedCredentialsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppSharedCredentialsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AppSharedCredentialsUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#id AppSharedCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#password AppSharedCredentials#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials#username AppSharedCredentials#username}
    */
    readonly username?: string;
}
export declare function appSharedCredentialsUsersToTerraform(struct?: AppSharedCredentialsUsers | cdktf.IResolvable): any;
export declare class AppSharedCredentialsUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSharedCredentialsUsers | cdktf.IResolvable | undefined;
    set internalValue(value: AppSharedCredentialsUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class AppSharedCredentialsUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSharedCredentialsUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSharedCredentialsUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials okta_app_shared_credentials}
*/
export declare class AppSharedCredentials extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_shared_credentials";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_shared_credentials okta_app_shared_credentials} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppSharedCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: AppSharedCredentialsConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _buttonField?;
    get buttonField(): string;
    set buttonField(value: string);
    resetButtonField(): void;
    get buttonFieldInput(): string | undefined;
    private _checkbox?;
    get checkbox(): string;
    set checkbox(value: string);
    resetCheckbox(): void;
    get checkboxInput(): string | undefined;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    get logoUrl(): string;
    get name(): string;
    private _passwordField?;
    get passwordField(): string;
    set passwordField(value: string);
    resetPasswordField(): void;
    get passwordFieldInput(): string | undefined;
    private _preconfiguredApp?;
    get preconfiguredApp(): string;
    set preconfiguredApp(value: string);
    resetPreconfiguredApp(): void;
    get preconfiguredAppInput(): string | undefined;
    private _redirectUrl?;
    get redirectUrl(): string;
    set redirectUrl(value: string);
    resetRedirectUrl(): void;
    get redirectUrlInput(): string | undefined;
    private _sharedPassword?;
    get sharedPassword(): string;
    set sharedPassword(value: string);
    resetSharedPassword(): void;
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    get sharedUsername(): string;
    set sharedUsername(value: string);
    resetSharedUsername(): void;
    get sharedUsernameInput(): string | undefined;
    get signOnMode(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _urlRegex?;
    get urlRegex(): string;
    set urlRegex(value: string);
    resetUrlRegex(): void;
    get urlRegexInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _usernameField?;
    get usernameField(): string;
    set usernameField(value: string);
    resetUsernameField(): void;
    get usernameFieldInput(): string | undefined;
    private _timeouts;
    get timeouts(): AppSharedCredentialsTimeoutsOutputReference;
    putTimeouts(value: AppSharedCredentialsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppSharedCredentialsTimeouts | undefined;
    private _users;
    get users(): AppSharedCredentialsUsersList;
    putUsers(value: AppSharedCredentialsUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | AppSharedCredentialsUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
