import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppSignonPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Allow or deny access based on the rule conditions: ALLOW or DENY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#access AppSignonPolicyRule#access}
    */
    readonly access?: string;
    /**
    * An array that contains nested Authenticator Constraint objects that are organized by the Authenticator class
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#constraints AppSignonPolicyRule#constraints}
    */
    readonly constraints?: string[];
    /**
    * This is an optional advanced setting. If the expression is formatted incorrectly or conflicts with conditions set above, the rule may not match any users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#custom_expression AppSignonPolicyRule#custom_expression}
    */
    readonly customExpression?: string;
    /**
    * If the device is managed. A device is managed if it's managed by a device management system. When managed is passed, registered must also be included and must be set to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#device_is_managed AppSignonPolicyRule#device_is_managed}
    */
    readonly deviceIsManaged?: boolean | cdktf.IResolvable;
    /**
    * If the device is registered. A device is registered if the User enrolls with Okta Verify that is installed on the device.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#device_is_registered AppSignonPolicyRule#device_is_registered}
    */
    readonly deviceIsRegistered?: boolean | cdktf.IResolvable;
    /**
    * The number of factors required to satisfy this assurance level
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#factor_mode AppSignonPolicyRule#factor_mode}
    */
    readonly factorMode?: string;
    /**
    * List of group IDs to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#groups_excluded AppSignonPolicyRule#groups_excluded}
    */
    readonly groupsExcluded?: string[];
    /**
    * List of group IDs to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#groups_included AppSignonPolicyRule#groups_included}
    */
    readonly groupsIncluded?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#id AppSignonPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The inactivity duration after which the end user must re-authenticate. Use the ISO 8601 Period format for recurring time intervals.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#inactivity_period AppSignonPolicyRule#inactivity_period}
    */
    readonly inactivityPeriod?: string;
    /**
    * Policy Rule Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#name AppSignonPolicyRule#name}
    */
    readonly name: string;
    /**
    * Network selection mode: ANYWHERE, ZONE, ON_NETWORK, or OFF_NETWORK.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#network_connection AppSignonPolicyRule#network_connection}
    */
    readonly networkConnection?: string;
    /**
    * The zones to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#network_excludes AppSignonPolicyRule#network_excludes}
    */
    readonly networkExcludes?: string[];
    /**
    * The zones to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#network_includes AppSignonPolicyRule#network_includes}
    */
    readonly networkIncludes?: string[];
    /**
    * ID of the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#policy_id AppSignonPolicyRule#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#priority AppSignonPolicyRule#priority}
    */
    readonly priority?: number;
    /**
    * The duration after which the end user must re-authenticate, regardless of user activity. Use the ISO 8601 Period format for recurring time intervals. PT0S - Every sign-in attempt, PT43800H - Once per session
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#re_authentication_frequency AppSignonPolicyRule#re_authentication_frequency}
    */
    readonly reAuthenticationFrequency?: string;
    /**
    * Status of the rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#status AppSignonPolicyRule#status}
    */
    readonly status?: string;
    /**
    * The Verification Method type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#type AppSignonPolicyRule#type}
    */
    readonly type?: string;
    /**
    * Set of User Type IDs to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#user_types_excluded AppSignonPolicyRule#user_types_excluded}
    */
    readonly userTypesExcluded?: string[];
    /**
    * Set of User Type IDs to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#user_types_included AppSignonPolicyRule#user_types_included}
    */
    readonly userTypesIncluded?: string[];
    /**
    * Set of User IDs to exclude
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#users_excluded AppSignonPolicyRule#users_excluded}
    */
    readonly usersExcluded?: string[];
    /**
    * Set of User IDs to include
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#users_included AppSignonPolicyRule#users_included}
    */
    readonly usersIncluded?: string[];
    /**
    * platform_include block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#platform_include AppSignonPolicyRule#platform_include}
    */
    readonly platformInclude?: AppSignonPolicyRulePlatformInclude[] | cdktf.IResolvable;
}
export interface AppSignonPolicyRulePlatformInclude {
    /**
    * Only available with OTHER OS type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#os_expression AppSignonPolicyRule#os_expression}
    */
    readonly osExpression?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#os_type AppSignonPolicyRule#os_type}
    */
    readonly osType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule#type AppSignonPolicyRule#type}
    */
    readonly type?: string;
}
export declare function appSignonPolicyRulePlatformIncludeToTerraform(struct?: AppSignonPolicyRulePlatformInclude | cdktf.IResolvable): any;
export declare class AppSignonPolicyRulePlatformIncludeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppSignonPolicyRulePlatformInclude | cdktf.IResolvable | undefined;
    set internalValue(value: AppSignonPolicyRulePlatformInclude | cdktf.IResolvable | undefined);
    private _osExpression?;
    get osExpression(): string;
    set osExpression(value: string);
    resetOsExpression(): void;
    get osExpressionInput(): string | undefined;
    private _osType?;
    get osType(): string;
    set osType(value: string);
    resetOsType(): void;
    get osTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class AppSignonPolicyRulePlatformIncludeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppSignonPolicyRulePlatformInclude[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppSignonPolicyRulePlatformIncludeOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule okta_app_signon_policy_rule}
*/
export declare class AppSignonPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_signon_policy_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy_rule okta_app_signon_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppSignonPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: AppSignonPolicyRuleConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    resetAccess(): void;
    get accessInput(): string | undefined;
    private _constraints?;
    get constraints(): string[];
    set constraints(value: string[]);
    resetConstraints(): void;
    get constraintsInput(): string[] | undefined;
    private _customExpression?;
    get customExpression(): string;
    set customExpression(value: string);
    resetCustomExpression(): void;
    get customExpressionInput(): string | undefined;
    private _deviceIsManaged?;
    get deviceIsManaged(): boolean | cdktf.IResolvable;
    set deviceIsManaged(value: boolean | cdktf.IResolvable);
    resetDeviceIsManaged(): void;
    get deviceIsManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _deviceIsRegistered?;
    get deviceIsRegistered(): boolean | cdktf.IResolvable;
    set deviceIsRegistered(value: boolean | cdktf.IResolvable);
    resetDeviceIsRegistered(): void;
    get deviceIsRegisteredInput(): boolean | cdktf.IResolvable | undefined;
    private _factorMode?;
    get factorMode(): string;
    set factorMode(value: string);
    resetFactorMode(): void;
    get factorModeInput(): string | undefined;
    private _groupsExcluded?;
    get groupsExcluded(): string[];
    set groupsExcluded(value: string[]);
    resetGroupsExcluded(): void;
    get groupsExcludedInput(): string[] | undefined;
    private _groupsIncluded?;
    get groupsIncluded(): string[];
    set groupsIncluded(value: string[]);
    resetGroupsIncluded(): void;
    get groupsIncludedInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inactivityPeriod?;
    get inactivityPeriod(): string;
    set inactivityPeriod(value: string);
    resetInactivityPeriod(): void;
    get inactivityPeriodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConnection?;
    get networkConnection(): string;
    set networkConnection(value: string);
    resetNetworkConnection(): void;
    get networkConnectionInput(): string | undefined;
    private _networkExcludes?;
    get networkExcludes(): string[];
    set networkExcludes(value: string[]);
    resetNetworkExcludes(): void;
    get networkExcludesInput(): string[] | undefined;
    private _networkIncludes?;
    get networkIncludes(): string[];
    set networkIncludes(value: string[]);
    resetNetworkIncludes(): void;
    get networkIncludesInput(): string[] | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _reAuthenticationFrequency?;
    get reAuthenticationFrequency(): string;
    set reAuthenticationFrequency(value: string);
    resetReAuthenticationFrequency(): void;
    get reAuthenticationFrequencyInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userTypesExcluded?;
    get userTypesExcluded(): string[];
    set userTypesExcluded(value: string[]);
    resetUserTypesExcluded(): void;
    get userTypesExcludedInput(): string[] | undefined;
    private _userTypesIncluded?;
    get userTypesIncluded(): string[];
    set userTypesIncluded(value: string[]);
    resetUserTypesIncluded(): void;
    get userTypesIncludedInput(): string[] | undefined;
    private _usersExcluded?;
    get usersExcluded(): string[];
    set usersExcluded(value: string[]);
    resetUsersExcluded(): void;
    get usersExcludedInput(): string[] | undefined;
    private _usersIncluded?;
    get usersIncluded(): string[];
    set usersIncluded(value: string[]);
    resetUsersIncluded(): void;
    get usersIncludedInput(): string[] | undefined;
    private _platformInclude;
    get platformInclude(): AppSignonPolicyRulePlatformIncludeList;
    putPlatformInclude(value: AppSignonPolicyRulePlatformInclude[] | cdktf.IResolvable): void;
    resetPlatformInclude(): void;
    get platformIncludeInput(): cdktf.IResolvable | AppSignonPolicyRulePlatformInclude[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
