import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppSignonPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Policy Description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy#description AppSignonPolicy#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy#id AppSignonPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Policy Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy#name AppSignonPolicy#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy okta_app_signon_policy}
*/
export declare class AppSignonPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_signon_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_signon_policy okta_app_signon_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppSignonPolicyConfig
    */
    constructor(scope: Construct, id: string, config: AppSignonPolicyConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
