import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppThreeFieldConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#accessibility_error_redirect_url AppThreeField#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#accessibility_login_redirect_url AppThreeField#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#accessibility_self_service AppThreeField#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#admin_note AppThreeField#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#app_links_json AppThreeField#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#auto_submit_toolbar AppThreeField#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * Login button field CSS selector
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#button_selector AppThreeField#button_selector}
    */
    readonly buttonSelector: string;
    /**
    * Application credentials scheme
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#credentials_scheme AppThreeField#credentials_scheme}
    */
    readonly credentialsScheme?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#enduser_note AppThreeField#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * Extra field CSS selector
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#extra_field_selector AppThreeField#extra_field_selector}
    */
    readonly extraFieldSelector: string;
    /**
    * Value for extra form field
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#extra_field_value AppThreeField#extra_field_value}
    */
    readonly extraFieldValue: string;
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#groups AppThreeField#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#hide_ios AppThreeField#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#hide_web AppThreeField#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#id AppThreeField#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#label AppThreeField#label}
    */
    readonly label: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#logo AppThreeField#logo}
    */
    readonly logo?: string;
    /**
    * Login password field CSS selector
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#password_selector AppThreeField#password_selector}
    */
    readonly passwordSelector: string;
    /**
    * Allow user to reveal password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#reveal_password AppThreeField#reveal_password}
    */
    readonly revealPassword?: boolean | cdktf.IResolvable;
    /**
    * Shared password, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#shared_password AppThreeField#shared_password}
    */
    readonly sharedPassword?: string;
    /**
    * Shared username, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#shared_username AppThreeField#shared_username}
    */
    readonly sharedUsername?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#skip_groups AppThreeField#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#skip_users AppThreeField#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#status AppThreeField#status}
    */
    readonly status?: string;
    /**
    * Login URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#url AppThreeField#url}
    */
    readonly url: string;
    /**
    * A regex that further restricts URL to the specified regex
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#url_regex AppThreeField#url_regex}
    */
    readonly urlRegex?: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#user_name_template AppThreeField#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#user_name_template_push_status AppThreeField#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#user_name_template_suffix AppThreeField#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#user_name_template_type AppThreeField#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * Login username field CSS selector
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#username_selector AppThreeField#username_selector}
    */
    readonly usernameSelector: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#timeouts AppThreeField#timeouts}
    */
    readonly timeouts?: AppThreeFieldTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#users AppThreeField#users}
    */
    readonly users?: AppThreeFieldUsers[] | cdktf.IResolvable;
}
export interface AppThreeFieldTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#create AppThreeField#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#read AppThreeField#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#update AppThreeField#update}
    */
    readonly update?: string;
}
export declare function appThreeFieldTimeoutsToTerraform(struct?: AppThreeFieldTimeoutsOutputReference | AppThreeFieldTimeouts | cdktf.IResolvable): any;
export declare class AppThreeFieldTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppThreeFieldTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppThreeFieldTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AppThreeFieldUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#id AppThreeField#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#password AppThreeField#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_three_field#username AppThreeField#username}
    */
    readonly username?: string;
}
export declare function appThreeFieldUsersToTerraform(struct?: AppThreeFieldUsers | cdktf.IResolvable): any;
export declare class AppThreeFieldUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppThreeFieldUsers | cdktf.IResolvable | undefined;
    set internalValue(value: AppThreeFieldUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class AppThreeFieldUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppThreeFieldUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppThreeFieldUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_three_field okta_app_three_field}
*/
export declare class AppThreeField extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_three_field";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_three_field okta_app_three_field} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppThreeFieldConfig
    */
    constructor(scope: Construct, id: string, config: AppThreeFieldConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _buttonSelector?;
    get buttonSelector(): string;
    set buttonSelector(value: string);
    get buttonSelectorInput(): string | undefined;
    private _credentialsScheme?;
    get credentialsScheme(): string;
    set credentialsScheme(value: string);
    resetCredentialsScheme(): void;
    get credentialsSchemeInput(): string | undefined;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    private _extraFieldSelector?;
    get extraFieldSelector(): string;
    set extraFieldSelector(value: string);
    get extraFieldSelectorInput(): string | undefined;
    private _extraFieldValue?;
    get extraFieldValue(): string;
    set extraFieldValue(value: string);
    get extraFieldValueInput(): string | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    get logoUrl(): string;
    get name(): string;
    private _passwordSelector?;
    get passwordSelector(): string;
    set passwordSelector(value: string);
    get passwordSelectorInput(): string | undefined;
    private _revealPassword?;
    get revealPassword(): boolean | cdktf.IResolvable;
    set revealPassword(value: boolean | cdktf.IResolvable);
    resetRevealPassword(): void;
    get revealPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedPassword?;
    get sharedPassword(): string;
    set sharedPassword(value: string);
    resetSharedPassword(): void;
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    get sharedUsername(): string;
    set sharedUsername(value: string);
    resetSharedUsername(): void;
    get sharedUsernameInput(): string | undefined;
    get signOnMode(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _urlRegex?;
    get urlRegex(): string;
    set urlRegex(value: string);
    resetUrlRegex(): void;
    get urlRegexInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _usernameSelector?;
    get usernameSelector(): string;
    set usernameSelector(value: string);
    get usernameSelectorInput(): string | undefined;
    private _timeouts;
    get timeouts(): AppThreeFieldTimeoutsOutputReference;
    putTimeouts(value: AppThreeFieldTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppThreeFieldTimeouts | undefined;
    private _users;
    get users(): AppThreeFieldUsersList;
    putUsers(value: AppThreeFieldUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | AppThreeFieldUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
