import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppUserSchemaPropertyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#app_id AppUserSchemaProperty#app_id}
    */
    readonly appId: string;
    /**
    * Custom Subschema enumerated value of a property of type array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#array_enum AppUserSchemaProperty#array_enum}
    */
    readonly arrayEnum?: string[];
    /**
    * Subschema array type: string, number, integer, reference. Type field must be an array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#array_type AppUserSchemaProperty#array_type}
    */
    readonly arrayType?: string;
    /**
    * Custom Subschema description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#description AppUserSchemaProperty#description}
    */
    readonly description?: string;
    /**
    * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#enum AppUserSchemaProperty#enum}
    */
    readonly enum?: string[];
    /**
    * Subschema external name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#external_name AppUserSchemaProperty#external_name}
    */
    readonly externalName?: string;
    /**
    * Subschema external namespace
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#external_namespace AppUserSchemaProperty#external_namespace}
    */
    readonly externalNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#id AppUserSchemaProperty#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Subschema unique string identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#index AppUserSchemaProperty#index}
    */
    readonly index: string;
    /**
    * SubSchema profile manager, if not set it will inherit its setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#master AppUserSchemaProperty#master}
    */
    readonly master?: string;
    /**
    * Subschema of type string maximum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#max_length AppUserSchemaProperty#max_length}
    */
    readonly maxLength?: number;
    /**
    * Subschema of type string minimum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#min_length AppUserSchemaProperty#min_length}
    */
    readonly minLength?: number;
    /**
    * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#permissions AppUserSchemaProperty#permissions}
    */
    readonly permissions?: string;
    /**
    * Whether the subschema is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#required AppUserSchemaProperty#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#scope AppUserSchemaProperty#scope}
    */
    readonly scope?: string;
    /**
    * Subschema title (display name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#title AppUserSchemaProperty#title}
    */
    readonly title: string;
    /**
    * Subschema type: string, boolean, number, integer, array, or object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#type AppUserSchemaProperty#type}
    */
    readonly type: string;
    /**
    * Allows to assign attribute's group priority
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#union AppUserSchemaProperty#union}
    */
    readonly union?: boolean | cdktf.IResolvable;
    /**
    * Subschema unique restriction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#unique AppUserSchemaProperty#unique}
    */
    readonly unique?: string;
    /**
    * Custom subschema user type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#user_type AppUserSchemaProperty#user_type}
    */
    readonly userType?: string;
    /**
    * array_one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#array_one_of AppUserSchemaProperty#array_one_of}
    */
    readonly arrayOneOf?: AppUserSchemaPropertyArrayOneOf[] | cdktf.IResolvable;
    /**
    * one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#one_of AppUserSchemaProperty#one_of}
    */
    readonly oneOf?: AppUserSchemaPropertyOneOf[] | cdktf.IResolvable;
}
export interface AppUserSchemaPropertyArrayOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#const AppUserSchemaProperty#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#title AppUserSchemaProperty#title}
    */
    readonly title: string;
}
export declare function appUserSchemaPropertyArrayOneOfToTerraform(struct?: AppUserSchemaPropertyArrayOneOf | cdktf.IResolvable): any;
export declare class AppUserSchemaPropertyArrayOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppUserSchemaPropertyArrayOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: AppUserSchemaPropertyArrayOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class AppUserSchemaPropertyArrayOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppUserSchemaPropertyArrayOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppUserSchemaPropertyArrayOneOfOutputReference;
}
export interface AppUserSchemaPropertyOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#const AppUserSchemaProperty#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property#title AppUserSchemaProperty#title}
    */
    readonly title: string;
}
export declare function appUserSchemaPropertyOneOfToTerraform(struct?: AppUserSchemaPropertyOneOf | cdktf.IResolvable): any;
export declare class AppUserSchemaPropertyOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppUserSchemaPropertyOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: AppUserSchemaPropertyOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class AppUserSchemaPropertyOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppUserSchemaPropertyOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppUserSchemaPropertyOneOfOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property okta_app_user_schema_property}
*/
export declare class AppUserSchemaProperty extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_user_schema_property";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema_property okta_app_user_schema_property} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppUserSchemaPropertyConfig
    */
    constructor(scope: Construct, id: string, config: AppUserSchemaPropertyConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _arrayEnum?;
    get arrayEnum(): string[];
    set arrayEnum(value: string[]);
    resetArrayEnum(): void;
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    get arrayType(): string;
    set arrayType(value: string);
    resetArrayType(): void;
    get arrayTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enum?;
    get enum(): string[];
    set enum(value: string[]);
    resetEnum(): void;
    get enumInput(): string[] | undefined;
    private _externalName?;
    get externalName(): string;
    set externalName(value: string);
    resetExternalName(): void;
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    get externalNamespace(): string;
    set externalNamespace(value: string);
    resetExternalNamespace(): void;
    get externalNamespaceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _master?;
    get master(): string;
    set master(value: string);
    resetMaster(): void;
    get masterInput(): string | undefined;
    private _maxLength?;
    get maxLength(): number;
    set maxLength(value: number);
    resetMaxLength(): void;
    get maxLengthInput(): number | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _union?;
    get union(): boolean | cdktf.IResolvable;
    set union(value: boolean | cdktf.IResolvable);
    resetUnion(): void;
    get unionInput(): boolean | cdktf.IResolvable | undefined;
    private _unique?;
    get unique(): string;
    set unique(value: string);
    resetUnique(): void;
    get uniqueInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    private _arrayOneOf;
    get arrayOneOf(): AppUserSchemaPropertyArrayOneOfList;
    putArrayOneOf(value: AppUserSchemaPropertyArrayOneOf[] | cdktf.IResolvable): void;
    resetArrayOneOf(): void;
    get arrayOneOfInput(): cdktf.IResolvable | AppUserSchemaPropertyArrayOneOf[] | undefined;
    private _oneOf;
    get oneOf(): AppUserSchemaPropertyOneOfList;
    putOneOf(value: AppUserSchemaPropertyOneOf[] | cdktf.IResolvable): void;
    resetOneOf(): void;
    get oneOfInput(): cdktf.IResolvable | AppUserSchemaPropertyOneOf[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
