import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppUserSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#app_id AppUserSchema#app_id}
    */
    readonly appId: string;
    /**
    * Custom Subschema enumerated value of a property of type array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#array_enum AppUserSchema#array_enum}
    */
    readonly arrayEnum?: string[];
    /**
    * Subschema array type: string, number, integer, reference. Type field must be an array.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#array_type AppUserSchema#array_type}
    */
    readonly arrayType?: string;
    /**
    * Custom Subschema description
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#description AppUserSchema#description}
    */
    readonly description?: string;
    /**
    * Custom Subschema enumerated value of the property. see: developer.okta.com/docs/api/resources/schemas#user-profile-schema-property-object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#enum AppUserSchema#enum}
    */
    readonly enum?: string[];
    /**
    * Subschema external name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#external_name AppUserSchema#external_name}
    */
    readonly externalName?: string;
    /**
    * Subschema external namespace
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#external_namespace AppUserSchema#external_namespace}
    */
    readonly externalNamespace?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#id AppUserSchema#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Subschema unique string identifier
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#index AppUserSchema#index}
    */
    readonly index: string;
    /**
    * SubSchema profile manager, if not set it will inherit its setting.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#master AppUserSchema#master}
    */
    readonly master?: string;
    /**
    * Subschema of type string maximum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#max_length AppUserSchema#max_length}
    */
    readonly maxLength?: number;
    /**
    * Subschema of type string minimum length
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#min_length AppUserSchema#min_length}
    */
    readonly minLength?: number;
    /**
    * SubSchema permissions: HIDE, READ_ONLY, or READ_WRITE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#permissions AppUserSchema#permissions}
    */
    readonly permissions?: string;
    /**
    * Whether the subschema is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#required AppUserSchema#required}
    */
    readonly required?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#scope AppUserSchema#scope}
    */
    readonly scope?: string;
    /**
    * Subschema title (display name)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#title AppUserSchema#title}
    */
    readonly title: string;
    /**
    * Subschema type: string, boolean, number, integer, array, or object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#type AppUserSchema#type}
    */
    readonly type: string;
    /**
    * Allows to assign attribute's group priority
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#union AppUserSchema#union}
    */
    readonly union?: boolean | cdktf.IResolvable;
    /**
    * Subschema unique restriction
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#unique AppUserSchema#unique}
    */
    readonly unique?: string;
    /**
    * Custom subschema user type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#user_type AppUserSchema#user_type}
    */
    readonly userType?: string;
    /**
    * array_one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#array_one_of AppUserSchema#array_one_of}
    */
    readonly arrayOneOf?: AppUserSchemaArrayOneOf[] | cdktf.IResolvable;
    /**
    * one_of block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#one_of AppUserSchema#one_of}
    */
    readonly oneOf?: AppUserSchemaOneOf[] | cdktf.IResolvable;
}
export interface AppUserSchemaArrayOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#const AppUserSchema#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#title AppUserSchema#title}
    */
    readonly title: string;
}
export declare function appUserSchemaArrayOneOfToTerraform(struct?: AppUserSchemaArrayOneOf | cdktf.IResolvable): any;
export declare class AppUserSchemaArrayOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppUserSchemaArrayOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: AppUserSchemaArrayOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class AppUserSchemaArrayOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppUserSchemaArrayOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppUserSchemaArrayOneOfOutputReference;
}
export interface AppUserSchemaOneOf {
    /**
    * Enum value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#const AppUserSchema#const}
    */
    readonly const: string;
    /**
    * Enum title
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema#title AppUserSchema#title}
    */
    readonly title: string;
}
export declare function appUserSchemaOneOfToTerraform(struct?: AppUserSchemaOneOf | cdktf.IResolvable): any;
export declare class AppUserSchemaOneOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AppUserSchemaOneOf | cdktf.IResolvable | undefined;
    set internalValue(value: AppUserSchemaOneOf | cdktf.IResolvable | undefined);
    private _const?;
    get const(): string;
    set const(value: string);
    get constInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export declare class AppUserSchemaOneOfList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AppUserSchemaOneOf[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AppUserSchemaOneOfOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema okta_app_user_schema}
*/
export declare class AppUserSchema extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_user_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_user_schema okta_app_user_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppUserSchemaConfig
    */
    constructor(scope: Construct, id: string, config: AppUserSchemaConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _arrayEnum?;
    get arrayEnum(): string[];
    set arrayEnum(value: string[]);
    resetArrayEnum(): void;
    get arrayEnumInput(): string[] | undefined;
    private _arrayType?;
    get arrayType(): string;
    set arrayType(value: string);
    resetArrayType(): void;
    get arrayTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enum?;
    get enum(): string[];
    set enum(value: string[]);
    resetEnum(): void;
    get enumInput(): string[] | undefined;
    private _externalName?;
    get externalName(): string;
    set externalName(value: string);
    resetExternalName(): void;
    get externalNameInput(): string | undefined;
    private _externalNamespace?;
    get externalNamespace(): string;
    set externalNamespace(value: string);
    resetExternalNamespace(): void;
    get externalNamespaceInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _index?;
    get index(): string;
    set index(value: string);
    get indexInput(): string | undefined;
    private _master?;
    get master(): string;
    set master(value: string);
    resetMaster(): void;
    get masterInput(): string | undefined;
    private _maxLength?;
    get maxLength(): number;
    set maxLength(value: number);
    resetMaxLength(): void;
    get maxLengthInput(): number | undefined;
    private _minLength?;
    get minLength(): number;
    set minLength(value: number);
    resetMinLength(): void;
    get minLengthInput(): number | undefined;
    private _permissions?;
    get permissions(): string;
    set permissions(value: string);
    resetPermissions(): void;
    get permissionsInput(): string | undefined;
    private _required?;
    get required(): boolean | cdktf.IResolvable;
    set required(value: boolean | cdktf.IResolvable);
    resetRequired(): void;
    get requiredInput(): boolean | cdktf.IResolvable | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _union?;
    get union(): boolean | cdktf.IResolvable;
    set union(value: boolean | cdktf.IResolvable);
    resetUnion(): void;
    get unionInput(): boolean | cdktf.IResolvable | undefined;
    private _unique?;
    get unique(): string;
    set unique(value: string);
    resetUnique(): void;
    get uniqueInput(): string | undefined;
    private _userType?;
    get userType(): string;
    set userType(value: string);
    resetUserType(): void;
    get userTypeInput(): string | undefined;
    private _arrayOneOf;
    get arrayOneOf(): AppUserSchemaArrayOneOfList;
    putArrayOneOf(value: AppUserSchemaArrayOneOf[] | cdktf.IResolvable): void;
    resetArrayOneOf(): void;
    get arrayOneOfInput(): cdktf.IResolvable | AppUserSchemaArrayOneOf[] | undefined;
    private _oneOf;
    get oneOf(): AppUserSchemaOneOfList;
    putOneOf(value: AppUserSchemaOneOf[] | cdktf.IResolvable): void;
    resetOneOf(): void;
    get oneOfInput(): cdktf.IResolvable | AppUserSchemaOneOf[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
