import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * App to associate user with
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#app_id AppUser#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#id AppUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#password AppUser#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#profile AppUser#profile}
    */
    readonly profile?: string;
    /**
    * Retain the user assignment on destroy. If set to true, the resource will be removed from state but not from the Okta app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#retain_assignment AppUser#retain_assignment}
    */
    readonly retainAssignment?: boolean | cdktf.IResolvable;
    /**
    * User associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#user_id AppUser#user_id}
    */
    readonly userId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/app_user#username AppUser#username}
    */
    readonly username?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/app_user okta_app_user}
*/
export declare class AppUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_app_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/app_user okta_app_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppUserConfig
    */
    constructor(scope: Construct, id: string, config: AppUserConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get hasSharedUsername(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _profile?;
    get profile(): string;
    set profile(value: string);
    resetProfile(): void;
    get profileInput(): string | undefined;
    private _retainAssignment?;
    get retainAssignment(): boolean | cdktf.IResolvable;
    set retainAssignment(value: boolean | cdktf.IResolvable);
    resetRetainAssignment(): void;
    get retainAssignmentInput(): boolean | cdktf.IResolvable | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
