import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthServerClaimDefaultConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default#always_include_in_token AuthServerClaimDefault#always_include_in_token}
    */
    readonly alwaysIncludeInToken?: boolean | cdktf.IResolvable;
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default#auth_server_id AuthServerClaimDefault#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default#id AuthServerClaimDefault#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Default auth server claim name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default#name AuthServerClaimDefault#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default#value AuthServerClaimDefault#value}
    */
    readonly value?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default okta_auth_server_claim_default}
*/
export declare class AuthServerClaimDefault extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_auth_server_claim_default";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim_default okta_auth_server_claim_default} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthServerClaimDefaultConfig
    */
    constructor(scope: Construct, id: string, config: AuthServerClaimDefaultConfig);
    private _alwaysIncludeInToken?;
    get alwaysIncludeInToken(): boolean | cdktf.IResolvable;
    set alwaysIncludeInToken(value: boolean | cdktf.IResolvable);
    resetAlwaysIncludeInToken(): void;
    get alwaysIncludeInTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    get claimType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get scopes(): string[];
    get status(): string;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
    get valueType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
