import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthServerClaimConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#always_include_in_token AuthServerClaim#always_include_in_token}
    */
    readonly alwaysIncludeInToken?: boolean | cdktf.IResolvable;
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#auth_server_id AuthServerClaim#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#claim_type AuthServerClaim#claim_type}
    */
    readonly claimType: string;
    /**
    * Required when value_type is GROUPS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#group_filter_type AuthServerClaim#group_filter_type}
    */
    readonly groupFilterType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#id AuthServerClaim#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Auth server claim name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#name AuthServerClaim#name}
    */
    readonly name: string;
    /**
    * Auth server claim list of scopes
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#scopes AuthServerClaim#scopes}
    */
    readonly scopes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#status AuthServerClaim#status}
    */
    readonly status?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#value AuthServerClaim#value}
    */
    readonly value: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim#value_type AuthServerClaim#value_type}
    */
    readonly valueType?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim okta_auth_server_claim}
*/
export declare class AuthServerClaim extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_auth_server_claim";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_claim okta_auth_server_claim} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthServerClaimConfig
    */
    constructor(scope: Construct, id: string, config: AuthServerClaimConfig);
    private _alwaysIncludeInToken?;
    get alwaysIncludeInToken(): boolean | cdktf.IResolvable;
    set alwaysIncludeInToken(value: boolean | cdktf.IResolvable);
    resetAlwaysIncludeInToken(): void;
    get alwaysIncludeInTokenInput(): boolean | cdktf.IResolvable | undefined;
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    private _claimType?;
    get claimType(): string;
    set claimType(value: string);
    get claimTypeInput(): string | undefined;
    private _groupFilterType?;
    get groupFilterType(): string;
    set groupFilterType(value: string);
    resetGroupFilterType(): void;
    get groupFilterTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scopes?;
    get scopes(): string[];
    set scopes(value: string[]);
    resetScopes(): void;
    get scopesInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
