import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthServerPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#access_token_lifetime_minutes AuthServerPolicyRule#access_token_lifetime_minutes}
    */
    readonly accessTokenLifetimeMinutes?: number;
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#auth_server_id AuthServerPolicyRule#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Accepted grant type values: authorization_code, implicit, password, client_credentials
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#grant_type_whitelist AuthServerPolicyRule#grant_type_whitelist}
    */
    readonly grantTypeWhitelist: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#group_blacklist AuthServerPolicyRule#group_blacklist}
    */
    readonly groupBlacklist?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#group_whitelist AuthServerPolicyRule#group_whitelist}
    */
    readonly groupWhitelist?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#id AuthServerPolicyRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#inline_hook_id AuthServerPolicyRule#inline_hook_id}
    */
    readonly inlineHookId?: string;
    /**
    * Auth server policy rule name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#name AuthServerPolicyRule#name}
    */
    readonly name: string;
    /**
    * Auth server policy ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#policy_id AuthServerPolicyRule#policy_id}
    */
    readonly policyId: string;
    /**
    * Priority of the auth server policy rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#priority AuthServerPolicyRule#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#refresh_token_lifetime_minutes AuthServerPolicyRule#refresh_token_lifetime_minutes}
    */
    readonly refreshTokenLifetimeMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#refresh_token_window_minutes AuthServerPolicyRule#refresh_token_window_minutes}
    */
    readonly refreshTokenWindowMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#scope_whitelist AuthServerPolicyRule#scope_whitelist}
    */
    readonly scopeWhitelist?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#status AuthServerPolicyRule#status}
    */
    readonly status?: string;
    /**
    * Auth server policy rule type, unlikely this will be anything other then the default
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#type AuthServerPolicyRule#type}
    */
    readonly type?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#user_blacklist AuthServerPolicyRule#user_blacklist}
    */
    readonly userBlacklist?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule#user_whitelist AuthServerPolicyRule#user_whitelist}
    */
    readonly userWhitelist?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule okta_auth_server_policy_rule}
*/
export declare class AuthServerPolicyRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_auth_server_policy_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_policy_rule okta_auth_server_policy_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthServerPolicyRuleConfig
    */
    constructor(scope: Construct, id: string, config: AuthServerPolicyRuleConfig);
    private _accessTokenLifetimeMinutes?;
    get accessTokenLifetimeMinutes(): number;
    set accessTokenLifetimeMinutes(value: number);
    resetAccessTokenLifetimeMinutes(): void;
    get accessTokenLifetimeMinutesInput(): number | undefined;
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    private _grantTypeWhitelist?;
    get grantTypeWhitelist(): string[];
    set grantTypeWhitelist(value: string[]);
    get grantTypeWhitelistInput(): string[] | undefined;
    private _groupBlacklist?;
    get groupBlacklist(): string[];
    set groupBlacklist(value: string[]);
    resetGroupBlacklist(): void;
    get groupBlacklistInput(): string[] | undefined;
    private _groupWhitelist?;
    get groupWhitelist(): string[];
    set groupWhitelist(value: string[]);
    resetGroupWhitelist(): void;
    get groupWhitelistInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inlineHookId?;
    get inlineHookId(): string;
    set inlineHookId(value: string);
    resetInlineHookId(): void;
    get inlineHookIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _refreshTokenLifetimeMinutes?;
    get refreshTokenLifetimeMinutes(): number;
    set refreshTokenLifetimeMinutes(value: number);
    resetRefreshTokenLifetimeMinutes(): void;
    get refreshTokenLifetimeMinutesInput(): number | undefined;
    private _refreshTokenWindowMinutes?;
    get refreshTokenWindowMinutes(): number;
    set refreshTokenWindowMinutes(value: number);
    resetRefreshTokenWindowMinutes(): void;
    get refreshTokenWindowMinutesInput(): number | undefined;
    private _scopeWhitelist?;
    get scopeWhitelist(): string[];
    set scopeWhitelist(value: string[]);
    resetScopeWhitelist(): void;
    get scopeWhitelistInput(): string[] | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userBlacklist?;
    get userBlacklist(): string[];
    set userBlacklist(value: string[]);
    resetUserBlacklist(): void;
    get userBlacklistInput(): string[] | undefined;
    private _userWhitelist?;
    get userWhitelist(): string[];
    set userWhitelist(value: string[]);
    resetUserWhitelist(): void;
    get userWhitelistInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
