import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthServerScopeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#auth_server_id AuthServerScope#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * EA Feature and thus it is simply ignored if the feature is off
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#consent AuthServerScope#consent}
    */
    readonly consent?: string;
    /**
    * A default scope will be returned in an access token when the client omits the scope parameter in a token request, provided this scope is allowed as part of the access policy rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#default AuthServerScope#default}
    */
    readonly default?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#description AuthServerScope#description}
    */
    readonly description?: string;
    /**
    * Name of the end user displayed in a consent dialog box
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#display_name AuthServerScope#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#id AuthServerScope#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether to publish metadata or not, matching API type despite the fact it could just be a boolean
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#metadata_publish AuthServerScope#metadata_publish}
    */
    readonly metadataPublish?: string;
    /**
    * Auth server scope name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope#name AuthServerScope#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope okta_auth_server_scope}
*/
export declare class AuthServerScope extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_auth_server_scope";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auth_server_scope okta_auth_server_scope} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthServerScopeConfig
    */
    constructor(scope: Construct, id: string, config: AuthServerScopeConfig);
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    private _consent?;
    get consent(): string;
    set consent(value: string);
    resetConsent(): void;
    get consentInput(): string | undefined;
    private _default?;
    get default(): boolean | cdktf.IResolvable;
    set default(value: boolean | cdktf.IResolvable);
    resetDefault(): void;
    get defaultInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadataPublish?;
    get metadataPublish(): string;
    set metadataPublish(value: string);
    resetMetadataPublish(): void;
    get metadataPublishInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get systemAttribute(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
