import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AuthenticatorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#id Authenticator#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A human-readable string that identifies the Authenticator
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#key Authenticator#key}
    */
    readonly key: string;
    /**
    * Display name of the Authenticator
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#name Authenticator#name}
    */
    readonly name: string;
    /**
    * The RADIUS server port (for example 1812). This is defined when the On-Prem RADIUS server is configured
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#provider_auth_port Authenticator#provider_auth_port}
    */
    readonly providerAuthPort?: number;
    /**
    * Server host name or IP address
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#provider_hostname Authenticator#provider_hostname}
    */
    readonly providerHostname?: string;
    /**
    * An authentication key that must be defined when the RADIUS server is configured, and must be the same on both the RADIUS client and server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#provider_shared_secret Authenticator#provider_shared_secret}
    */
    readonly providerSharedSecret?: string;
    /**
    * Format expected by the provider
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#provider_user_name_template Authenticator#provider_user_name_template}
    */
    readonly providerUserNameTemplate?: string;
    /**
    * Authenticator settings in JSON format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#settings Authenticator#settings}
    */
    readonly settings?: string;
    /**
    * Authenticator status: ACTIVE or INACTIVE
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/authenticator#status Authenticator#status}
    */
    readonly status?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/authenticator okta_authenticator}
*/
export declare class Authenticator extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_authenticator";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/authenticator okta_authenticator} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AuthenticatorConfig
    */
    constructor(scope: Construct, id: string, config: AuthenticatorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _providerAuthPort?;
    get providerAuthPort(): number;
    set providerAuthPort(value: number);
    resetProviderAuthPort(): void;
    get providerAuthPortInput(): number | undefined;
    private _providerHostname?;
    get providerHostname(): string;
    set providerHostname(value: string);
    resetProviderHostname(): void;
    get providerHostnameInput(): string | undefined;
    get providerInstanceId(): string;
    private _providerSharedSecret?;
    get providerSharedSecret(): string;
    set providerSharedSecret(value: string);
    resetProviderSharedSecret(): void;
    get providerSharedSecretInput(): string | undefined;
    get providerType(): string;
    private _providerUserNameTemplate?;
    get providerUserNameTemplate(): string;
    set providerUserNameTemplate(value: string);
    resetProviderUserNameTemplate(): void;
    get providerUserNameTemplateInput(): string | undefined;
    private _settings?;
    get settings(): string;
    set settings(value: string);
    resetSettings(): void;
    get settingsInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
