import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutoLoginAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Custom error page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#accessibility_error_redirect_url AutoLoginApp#accessibility_error_redirect_url}
    */
    readonly accessibilityErrorRedirectUrl?: string;
    /**
    * Custom login page URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#accessibility_login_redirect_url AutoLoginApp#accessibility_login_redirect_url}
    */
    readonly accessibilityLoginRedirectUrl?: string;
    /**
    * Enable self service
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#accessibility_self_service AutoLoginApp#accessibility_self_service}
    */
    readonly accessibilitySelfService?: boolean | cdktf.IResolvable;
    /**
    * Application notes for admins.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#admin_note AutoLoginApp#admin_note}
    */
    readonly adminNote?: string;
    /**
    * Displays specific appLinks for the app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#app_links_json AutoLoginApp#app_links_json}
    */
    readonly appLinksJson?: string;
    /**
    * Application settings in JSON format
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#app_settings_json AutoLoginApp#app_settings_json}
    */
    readonly appSettingsJson?: string;
    /**
    * Display auto submit toolbar
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#auto_submit_toolbar AutoLoginApp#auto_submit_toolbar}
    */
    readonly autoSubmitToolbar?: boolean | cdktf.IResolvable;
    /**
    * Application credentials scheme
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#credentials_scheme AutoLoginApp#credentials_scheme}
    */
    readonly credentialsScheme?: string;
    /**
    * Application notes for end users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#enduser_note AutoLoginApp#enduser_note}
    */
    readonly enduserNote?: string;
    /**
    * Groups associated with the application
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#groups AutoLoginApp#groups}
    */
    readonly groups?: string[];
    /**
    * Do not display application icon on mobile app
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#hide_ios AutoLoginApp#hide_ios}
    */
    readonly hideIos?: boolean | cdktf.IResolvable;
    /**
    * Do not display application icon to users
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#hide_web AutoLoginApp#hide_web}
    */
    readonly hideWeb?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#id AutoLoginApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Pretty name of app.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#label AutoLoginApp#label}
    */
    readonly label: string;
    /**
    * Local path to logo of the application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#logo AutoLoginApp#logo}
    */
    readonly logo?: string;
    /**
    * Preconfigured app name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#preconfigured_app AutoLoginApp#preconfigured_app}
    */
    readonly preconfiguredApp?: string;
    /**
    * Allow user to reveal password
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#reveal_password AutoLoginApp#reveal_password}
    */
    readonly revealPassword?: boolean | cdktf.IResolvable;
    /**
    * Shared password, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#shared_password AutoLoginApp#shared_password}
    */
    readonly sharedPassword?: string;
    /**
    * Shared username, required for certain schemes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#shared_username AutoLoginApp#shared_username}
    */
    readonly sharedUsername?: string;
    /**
    * Post login redirect URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#sign_on_redirect_url AutoLoginApp#sign_on_redirect_url}
    */
    readonly signOnRedirectUrl?: string;
    /**
    * Login URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#sign_on_url AutoLoginApp#sign_on_url}
    */
    readonly signOnUrl?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#skip_groups AutoLoginApp#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#skip_users AutoLoginApp#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
    /**
    * Status of application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#status AutoLoginApp#status}
    */
    readonly status?: string;
    /**
    * Username template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#user_name_template AutoLoginApp#user_name_template}
    */
    readonly userNameTemplate?: string;
    /**
    * Push username on update
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#user_name_template_push_status AutoLoginApp#user_name_template_push_status}
    */
    readonly userNameTemplatePushStatus?: string;
    /**
    * Username template suffix
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#user_name_template_suffix AutoLoginApp#user_name_template_suffix}
    */
    readonly userNameTemplateSuffix?: string;
    /**
    * Username template type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#user_name_template_type AutoLoginApp#user_name_template_type}
    */
    readonly userNameTemplateType?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#timeouts AutoLoginApp#timeouts}
    */
    readonly timeouts?: AutoLoginAppTimeouts;
    /**
    * users block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#users AutoLoginApp#users}
    */
    readonly users?: AutoLoginAppUsers[] | cdktf.IResolvable;
}
export interface AutoLoginAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#create AutoLoginApp#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#read AutoLoginApp#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#update AutoLoginApp#update}
    */
    readonly update?: string;
}
export declare function autoLoginAppTimeoutsToTerraform(struct?: AutoLoginAppTimeoutsOutputReference | AutoLoginAppTimeouts | cdktf.IResolvable): any;
export declare class AutoLoginAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutoLoginAppTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutoLoginAppTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface AutoLoginAppUsers {
    /**
    * User ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#id AutoLoginApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Password for user application.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#password AutoLoginApp#password}
    */
    readonly password?: string;
    /**
    * Username for user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app#username AutoLoginApp#username}
    */
    readonly username?: string;
}
export declare function autoLoginAppUsersToTerraform(struct?: AutoLoginAppUsers | cdktf.IResolvable): any;
export declare class AutoLoginAppUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutoLoginAppUsers | cdktf.IResolvable | undefined;
    set internalValue(value: AutoLoginAppUsers | cdktf.IResolvable | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    get scope(): string;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class AutoLoginAppUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutoLoginAppUsers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutoLoginAppUsersOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app okta_auto_login_app}
*/
export declare class AutoLoginApp extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_auto_login_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/auto_login_app okta_auto_login_app} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutoLoginAppConfig
    */
    constructor(scope: Construct, id: string, config: AutoLoginAppConfig);
    private _accessibilityErrorRedirectUrl?;
    get accessibilityErrorRedirectUrl(): string;
    set accessibilityErrorRedirectUrl(value: string);
    resetAccessibilityErrorRedirectUrl(): void;
    get accessibilityErrorRedirectUrlInput(): string | undefined;
    private _accessibilityLoginRedirectUrl?;
    get accessibilityLoginRedirectUrl(): string;
    set accessibilityLoginRedirectUrl(value: string);
    resetAccessibilityLoginRedirectUrl(): void;
    get accessibilityLoginRedirectUrlInput(): string | undefined;
    private _accessibilitySelfService?;
    get accessibilitySelfService(): boolean | cdktf.IResolvable;
    set accessibilitySelfService(value: boolean | cdktf.IResolvable);
    resetAccessibilitySelfService(): void;
    get accessibilitySelfServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _adminNote?;
    get adminNote(): string;
    set adminNote(value: string);
    resetAdminNote(): void;
    get adminNoteInput(): string | undefined;
    private _appLinksJson?;
    get appLinksJson(): string;
    set appLinksJson(value: string);
    resetAppLinksJson(): void;
    get appLinksJsonInput(): string | undefined;
    private _appSettingsJson?;
    get appSettingsJson(): string;
    set appSettingsJson(value: string);
    resetAppSettingsJson(): void;
    get appSettingsJsonInput(): string | undefined;
    private _autoSubmitToolbar?;
    get autoSubmitToolbar(): boolean | cdktf.IResolvable;
    set autoSubmitToolbar(value: boolean | cdktf.IResolvable);
    resetAutoSubmitToolbar(): void;
    get autoSubmitToolbarInput(): boolean | cdktf.IResolvable | undefined;
    private _credentialsScheme?;
    get credentialsScheme(): string;
    set credentialsScheme(value: string);
    resetCredentialsScheme(): void;
    get credentialsSchemeInput(): string | undefined;
    private _enduserNote?;
    get enduserNote(): string;
    set enduserNote(value: string);
    resetEnduserNote(): void;
    get enduserNoteInput(): string | undefined;
    private _groups?;
    get groups(): string[];
    set groups(value: string[]);
    resetGroups(): void;
    get groupsInput(): string[] | undefined;
    private _hideIos?;
    get hideIos(): boolean | cdktf.IResolvable;
    set hideIos(value: boolean | cdktf.IResolvable);
    resetHideIos(): void;
    get hideIosInput(): boolean | cdktf.IResolvable | undefined;
    private _hideWeb?;
    get hideWeb(): boolean | cdktf.IResolvable;
    set hideWeb(value: boolean | cdktf.IResolvable);
    resetHideWeb(): void;
    get hideWebInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    get labelInput(): string | undefined;
    private _logo?;
    get logo(): string;
    set logo(value: string);
    resetLogo(): void;
    get logoInput(): string | undefined;
    get logoUrl(): string;
    get name(): string;
    private _preconfiguredApp?;
    get preconfiguredApp(): string;
    set preconfiguredApp(value: string);
    resetPreconfiguredApp(): void;
    get preconfiguredAppInput(): string | undefined;
    private _revealPassword?;
    get revealPassword(): boolean | cdktf.IResolvable;
    set revealPassword(value: boolean | cdktf.IResolvable);
    resetRevealPassword(): void;
    get revealPasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _sharedPassword?;
    get sharedPassword(): string;
    set sharedPassword(value: string);
    resetSharedPassword(): void;
    get sharedPasswordInput(): string | undefined;
    private _sharedUsername?;
    get sharedUsername(): string;
    set sharedUsername(value: string);
    resetSharedUsername(): void;
    get sharedUsernameInput(): string | undefined;
    get signOnMode(): string;
    private _signOnRedirectUrl?;
    get signOnRedirectUrl(): string;
    set signOnRedirectUrl(value: string);
    resetSignOnRedirectUrl(): void;
    get signOnRedirectUrlInput(): string | undefined;
    private _signOnUrl?;
    get signOnUrl(): string;
    set signOnUrl(value: string);
    resetSignOnUrl(): void;
    get signOnUrlInput(): string | undefined;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _userNameTemplate?;
    get userNameTemplate(): string;
    set userNameTemplate(value: string);
    resetUserNameTemplate(): void;
    get userNameTemplateInput(): string | undefined;
    private _userNameTemplatePushStatus?;
    get userNameTemplatePushStatus(): string;
    set userNameTemplatePushStatus(value: string);
    resetUserNameTemplatePushStatus(): void;
    get userNameTemplatePushStatusInput(): string | undefined;
    private _userNameTemplateSuffix?;
    get userNameTemplateSuffix(): string;
    set userNameTemplateSuffix(value: string);
    resetUserNameTemplateSuffix(): void;
    get userNameTemplateSuffixInput(): string | undefined;
    private _userNameTemplateType?;
    get userNameTemplateType(): string;
    set userNameTemplateType(value: string);
    resetUserNameTemplateType(): void;
    get userNameTemplateTypeInput(): string | undefined;
    private _timeouts;
    get timeouts(): AutoLoginAppTimeoutsOutputReference;
    putTimeouts(value: AutoLoginAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutoLoginAppTimeouts | undefined;
    private _users;
    get users(): AutoLoginAppUsersList;
    putUsers(value: AutoLoginAppUsers[] | cdktf.IResolvable): void;
    resetUsers(): void;
    get usersInput(): cdktf.IResolvable | AutoLoginAppUsers[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
