import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BehaviorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#id Behavior#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Determines the method and level of detail used to evaluate the behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#location_granularity_type Behavior#location_granularity_type}
    */
    readonly locationGranularityType?: string;
    /**
    * Name of the behavior
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#name Behavior#name}
    */
    readonly name: string;
    /**
    * The number of recent authentications used to evaluate the behavior.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#number_of_authentications Behavior#number_of_authentications}
    */
    readonly numberOfAuthentications?: number;
    /**
    * Radius from location (in kilometers)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#radius_from_location Behavior#radius_from_location}
    */
    readonly radiusFromLocation?: number;
    /**
    * Behavior status: ACTIVE or INACTIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#status Behavior#status}
    */
    readonly status?: string;
    /**
    * Behavior type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#type Behavior#type}
    */
    readonly type: string;
    /**
    * Velocity (in kilometers per hour).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/behavior#velocity Behavior#velocity}
    */
    readonly velocity?: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/behavior okta_behavior}
*/
export declare class Behavior extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_behavior";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/behavior okta_behavior} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BehaviorConfig
    */
    constructor(scope: Construct, id: string, config: BehaviorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _locationGranularityType?;
    get locationGranularityType(): string;
    set locationGranularityType(value: string);
    resetLocationGranularityType(): void;
    get locationGranularityTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _numberOfAuthentications?;
    get numberOfAuthentications(): number;
    set numberOfAuthentications(value: number);
    resetNumberOfAuthentications(): void;
    get numberOfAuthenticationsInput(): number | undefined;
    private _radiusFromLocation?;
    get radiusFromLocation(): number;
    set radiusFromLocation(value: number);
    resetRadiusFromLocation(): void;
    get radiusFromLocationInput(): number | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _velocity?;
    get velocity(): number;
    set velocity(value: number);
    resetVelocity(): void;
    get velocityInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
