import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BrandConfig extends cdktf.TerraformMetaArguments {
    /**
    * Consent for updating the custom privacy policy URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/brand#agree_to_custom_privacy_policy Brand#agree_to_custom_privacy_policy}
    */
    readonly agreeToCustomPrivacyPolicy?: boolean | cdktf.IResolvable;
    /**
    * Brand ID - Note: Okta API for brands only reads and updates therefore the okta_brand resource needs to act as a quasi data source. Do this by setting brand_id.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/brand#brand_id Brand#brand_id}
    */
    readonly brandId?: string;
    /**
    * Custom privacy policy URL
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/brand#custom_privacy_policy_url Brand#custom_privacy_policy_url}
    */
    readonly customPrivacyPolicyUrl?: string;
    /**
    * Removes "Powered by Okta" from the Okta-hosted sign-in page and "© 2021 Okta, Inc." from the Okta End-User Dashboard
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/brand#remove_powered_by_okta Brand#remove_powered_by_okta}
    */
    readonly removePoweredByOkta?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/brand okta_brand}
*/
export declare class Brand extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_brand";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/brand okta_brand} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BrandConfig = {}
    */
    constructor(scope: Construct, id: string, config?: BrandConfig);
    private _agreeToCustomPrivacyPolicy?;
    get agreeToCustomPrivacyPolicy(): boolean | cdktf.IResolvable;
    set agreeToCustomPrivacyPolicy(value: boolean | cdktf.IResolvable);
    resetAgreeToCustomPrivacyPolicy(): void;
    get agreeToCustomPrivacyPolicyInput(): boolean | cdktf.IResolvable | undefined;
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    resetBrandId(): void;
    get brandIdInput(): string | undefined;
    private _customPrivacyPolicyUrl?;
    get customPrivacyPolicyUrl(): string;
    set customPrivacyPolicyUrl(value: string);
    resetCustomPrivacyPolicyUrl(): void;
    get customPrivacyPolicyUrlInput(): string | undefined;
    get id(): string;
    get links(): string;
    private _removePoweredByOkta?;
    get removePoweredByOkta(): boolean | cdktf.IResolvable;
    set removePoweredByOkta(value: boolean | cdktf.IResolvable);
    resetRemovePoweredByOkta(): void;
    get removePoweredByOktaInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
