"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Brand = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/brand okta_brand}
*/
class Brand extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/brand okta_brand} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BrandConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'okta_brand',
            terraformGeneratorMetadata: {
                providerName: 'okta',
                providerVersion: '3.35.0',
                providerVersionConstraint: '~> 3.20'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._agreeToCustomPrivacyPolicy = config.agreeToCustomPrivacyPolicy;
        this._brandId = config.brandId;
        this._customPrivacyPolicyUrl = config.customPrivacyPolicyUrl;
        this._removePoweredByOkta = config.removePoweredByOkta;
    }
    get agreeToCustomPrivacyPolicy() {
        return this.getBooleanAttribute('agree_to_custom_privacy_policy');
    }
    set agreeToCustomPrivacyPolicy(value) {
        this._agreeToCustomPrivacyPolicy = value;
    }
    resetAgreeToCustomPrivacyPolicy() {
        this._agreeToCustomPrivacyPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get agreeToCustomPrivacyPolicyInput() {
        return this._agreeToCustomPrivacyPolicy;
    }
    get brandId() {
        return this.getStringAttribute('brand_id');
    }
    set brandId(value) {
        this._brandId = value;
    }
    resetBrandId() {
        this._brandId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get brandIdInput() {
        return this._brandId;
    }
    get customPrivacyPolicyUrl() {
        return this.getStringAttribute('custom_privacy_policy_url');
    }
    set customPrivacyPolicyUrl(value) {
        this._customPrivacyPolicyUrl = value;
    }
    resetCustomPrivacyPolicyUrl() {
        this._customPrivacyPolicyUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customPrivacyPolicyUrlInput() {
        return this._customPrivacyPolicyUrl;
    }
    // id - computed: true, optional: false, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // links - computed: true, optional: false, required: false
    get links() {
        return this.getStringAttribute('links');
    }
    get removePoweredByOkta() {
        return this.getBooleanAttribute('remove_powered_by_okta');
    }
    set removePoweredByOkta(value) {
        this._removePoweredByOkta = value;
    }
    resetRemovePoweredByOkta() {
        this._removePoweredByOkta = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get removePoweredByOktaInput() {
        return this._removePoweredByOkta;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            agree_to_custom_privacy_policy: cdktf.booleanToTerraform(this._agreeToCustomPrivacyPolicy),
            brand_id: cdktf.stringToTerraform(this._brandId),
            custom_privacy_policy_url: cdktf.stringToTerraform(this._customPrivacyPolicyUrl),
            remove_powered_by_okta: cdktf.booleanToTerraform(this._removePoweredByOkta),
        };
    }
}
exports.Brand = Brand;
_a = JSII_RTTI_SYMBOL_1;
Brand[_a] = { fqn: "@cdktf/provider-okta.Brand", version: "2.0.46" };
// =================
// STATIC PROPERTIES
// =================
Brand.tfResourceType = "okta_brand";
//# sourceMappingURL=data:application/json;base64,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