import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CaptchaOrgWideSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the CAPTCHA
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings#captcha_id CaptchaOrgWideSettings#captcha_id}
    */
    readonly captchaId?: string;
    /**
    * Set of pages that have CAPTCHA enabled
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings#enabled_for CaptchaOrgWideSettings#enabled_for}
    */
    readonly enabledFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings#id CaptchaOrgWideSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings okta_captcha_org_wide_settings}
*/
export declare class CaptchaOrgWideSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_captcha_org_wide_settings";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/captcha_org_wide_settings okta_captcha_org_wide_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CaptchaOrgWideSettingsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: CaptchaOrgWideSettingsConfig);
    private _captchaId?;
    get captchaId(): string;
    set captchaId(value: string);
    resetCaptchaId(): void;
    get captchaIdInput(): string | undefined;
    private _enabledFor?;
    get enabledFor(): string[];
    set enabledFor(value: string[]);
    resetEnabledFor(): void;
    get enabledForInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
