import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CaptchaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha#id Captcha#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the CAPTCHA
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha#name Captcha#name}
    */
    readonly name: string;
    /**
    * Secret key issued from the CAPTCHA vendor to perform server-side validation for a CAPTCHA token
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha#secret_key Captcha#secret_key}
    */
    readonly secretKey: string;
    /**
    * Site key issued from the CAPTCHA vendor to render a CAPTCHA on a page
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha#site_key Captcha#site_key}
    */
    readonly siteKey: string;
    /**
    * Captcha type
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/r/captcha#type Captcha#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/r/captcha okta_captcha}
*/
export declare class Captcha extends cdktf.TerraformResource {
    static readonly tfResourceType = "okta_captcha";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/r/captcha okta_captcha} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CaptchaConfig
    */
    constructor(scope: Construct, id: string, config: CaptchaConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secretKey?;
    get secretKey(): string;
    set secretKey(value: string);
    get secretKeyInput(): string | undefined;
    private _siteKey?;
    get siteKey(): string;
    set siteKey(value: string);
    get siteKeyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
