import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAppMetadataSamlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml#app_id DataOktaAppMetadataSaml#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml#id DataOktaAppMetadataSaml#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml#key_id DataOktaAppMetadataSaml#key_id}
    */
    readonly keyId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml okta_app_metadata_saml}
*/
export declare class DataOktaAppMetadataSaml extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_app_metadata_saml";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_metadata_saml okta_app_metadata_saml} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAppMetadataSamlConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAppMetadataSamlConfig);
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    get certificate(): string;
    get entityId(): string;
    get httpPostBinding(): string;
    get httpRedirectBinding(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyId?;
    get keyId(): string;
    set keyId(value: string);
    resetKeyId(): void;
    get keyIdInput(): string | undefined;
    get metadata(): string;
    get wantAuthnRequestsSigned(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
