import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAppOauthConfig extends cdktf.TerraformMetaArguments {
    /**
    * Search only ACTIVE applications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth#active_only DataOktaAppOauth#active_only}
    */
    readonly activeOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth#id DataOktaAppOauth#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth#label DataOktaAppOauth#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth#label_prefix DataOktaAppOauth#label_prefix}
    */
    readonly labelPrefix?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth#skip_groups DataOktaAppOauth#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_oauth#skip_users DataOktaAppOauth#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_oauth okta_app_oauth}
*/
export declare class DataOktaAppOauth extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_app_oauth";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_oauth okta_app_oauth} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAppOauthConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaAppOauthConfig);
    private _activeOnly?;
    get activeOnly(): boolean | cdktf.IResolvable;
    set activeOnly(value: boolean | cdktf.IResolvable);
    resetActiveOnly(): void;
    get activeOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get autoSubmitToolbar(): cdktf.IResolvable;
    get clientId(): string;
    get clientUri(): string;
    get grantTypes(): string[];
    get groups(): string[];
    get hideIos(): cdktf.IResolvable;
    get hideWeb(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _labelPrefix?;
    get labelPrefix(): string;
    set labelPrefix(value: string);
    resetLabelPrefix(): void;
    get labelPrefixInput(): string | undefined;
    get links(): string;
    get loginMode(): string;
    get loginScopes(): string[];
    get loginUri(): string;
    get logoUri(): string;
    get name(): string;
    get policyUri(): string;
    get postLogoutRedirectUris(): string[];
    get redirectUris(): string[];
    get responseTypes(): string[];
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    get type(): string;
    get users(): string[];
    get wildcardRedirect(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
