import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAppSamlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Search only ACTIVE applications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#active_only DataOktaAppSaml#active_only}
    */
    readonly activeOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#id DataOktaAppSaml#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#label DataOktaAppSaml#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#label_prefix DataOktaAppSaml#label_prefix}
    */
    readonly labelPrefix?: string;
    /**
    * Denotes whether the request is compressed or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#request_compressed DataOktaAppSaml#request_compressed}
    */
    readonly requestCompressed?: boolean | cdktf.IResolvable;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#skip_groups DataOktaAppSaml#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_saml#skip_users DataOktaAppSaml#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
}
export interface DataOktaAppSamlAttributeStatements {
}
export declare function dataOktaAppSamlAttributeStatementsToTerraform(struct?: DataOktaAppSamlAttributeStatements): any;
export declare class DataOktaAppSamlAttributeStatementsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaAppSamlAttributeStatements | undefined;
    set internalValue(value: DataOktaAppSamlAttributeStatements | undefined);
    get filterType(): string;
    get filterValue(): string;
    get name(): string;
    get namespace(): string;
    get type(): string;
    get values(): string[];
}
export declare class DataOktaAppSamlAttributeStatementsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaAppSamlAttributeStatementsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_saml okta_app_saml}
*/
export declare class DataOktaAppSaml extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_app_saml";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_saml okta_app_saml} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAppSamlConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaAppSamlConfig);
    get accessibilityErrorRedirectUrl(): string;
    get accessibilityLoginRedirectUrl(): string;
    get accessibilitySelfService(): cdktf.IResolvable;
    get acsEndpoints(): string[];
    private _activeOnly?;
    get activeOnly(): boolean | cdktf.IResolvable;
    set activeOnly(value: boolean | cdktf.IResolvable);
    resetActiveOnly(): void;
    get activeOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get appSettingsJson(): string;
    get assertionSigned(): cdktf.IResolvable;
    private _attributeStatements;
    get attributeStatements(): DataOktaAppSamlAttributeStatementsList;
    get audience(): string;
    get authnContextClassRef(): string;
    get autoSubmitToolbar(): cdktf.IResolvable;
    get defaultRelayState(): string;
    get destination(): string;
    get digestAlgorithm(): string;
    get features(): string[];
    get groups(): string[];
    get hideIos(): cdktf.IResolvable;
    get hideWeb(): cdktf.IResolvable;
    get honorForceAuthn(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get idpIssuer(): string;
    get inlineHookId(): string;
    get keyId(): string;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _labelPrefix?;
    get labelPrefix(): string;
    set labelPrefix(value: string);
    resetLabelPrefix(): void;
    get labelPrefixInput(): string | undefined;
    get links(): string;
    get name(): string;
    get recipient(): string;
    private _requestCompressed?;
    get requestCompressed(): boolean | cdktf.IResolvable;
    set requestCompressed(value: boolean | cdktf.IResolvable);
    resetRequestCompressed(): void;
    get requestCompressedInput(): boolean | cdktf.IResolvable | undefined;
    get responseSigned(): cdktf.IResolvable;
    get signatureAlgorithm(): string;
    get singleLogoutCertificate(): string;
    get singleLogoutIssuer(): string;
    get singleLogoutUrl(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    get spIssuer(): string;
    get ssoUrl(): string;
    get status(): string;
    get subjectNameIdFormat(): string;
    get subjectNameIdTemplate(): string;
    get userNameTemplate(): string;
    get userNameTemplatePushStatus(): string;
    get userNameTemplateSuffix(): string;
    get userNameTemplateType(): string;
    get users(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
