import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAppUserAssignmentsConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the Okta App being queried for groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments#id DataOktaAppUserAssignments#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments okta_app_user_assignments}
*/
export declare class DataOktaAppUserAssignments extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_app_user_assignments";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app_user_assignments okta_app_user_assignments} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAppUserAssignmentsConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAppUserAssignmentsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    get users(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
