import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Search only ACTIVE applications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app#active_only DataOktaApp#active_only}
    */
    readonly activeOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app#id DataOktaApp#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app#label DataOktaApp#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app#label_prefix DataOktaApp#label_prefix}
    */
    readonly labelPrefix?: string;
    /**
    * Ignore groups sync. This is a temporary solution until 'groups' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app#skip_groups DataOktaApp#skip_groups}
    */
    readonly skipGroups?: boolean | cdktf.IResolvable;
    /**
    * Ignore users sync. This is a temporary solution until 'users' field is supported in all the app-like resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/app#skip_users DataOktaApp#skip_users}
    */
    readonly skipUsers?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/app okta_app}
*/
export declare class DataOktaApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_app";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/app okta_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAppConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaAppConfig);
    private _activeOnly?;
    get activeOnly(): boolean | cdktf.IResolvable;
    set activeOnly(value: boolean | cdktf.IResolvable);
    resetActiveOnly(): void;
    get activeOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get groups(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _labelPrefix?;
    get labelPrefix(): string;
    set labelPrefix(value: string);
    resetLabelPrefix(): void;
    get labelPrefixInput(): string | undefined;
    get links(): string;
    get name(): string;
    private _skipGroups?;
    get skipGroups(): boolean | cdktf.IResolvable;
    set skipGroups(value: boolean | cdktf.IResolvable);
    resetSkipGroups(): void;
    get skipGroupsInput(): boolean | cdktf.IResolvable | undefined;
    private _skipUsers?;
    get skipUsers(): boolean | cdktf.IResolvable;
    set skipUsers(value: boolean | cdktf.IResolvable);
    resetSkipUsers(): void;
    get skipUsersInput(): boolean | cdktf.IResolvable | undefined;
    get status(): string;
    get users(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
