import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAuthServerClaimConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim#auth_server_id DataOktaAuthServerClaim#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim#id DataOktaAuthServerClaim#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim#name DataOktaAuthServerClaim#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim okta_auth_server_claim}
*/
export declare class DataOktaAuthServerClaim extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_auth_server_claim";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claim okta_auth_server_claim} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAuthServerClaimConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerClaimConfig);
    get alwaysIncludeInToken(): cdktf.IResolvable;
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    get claimType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get scopes(): string[];
    get status(): string;
    get value(): string;
    get valueType(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
