import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAuthServerClaimsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims#auth_server_id DataOktaAuthServerClaims#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims#id DataOktaAuthServerClaims#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataOktaAuthServerClaimsClaims {
}
export declare function dataOktaAuthServerClaimsClaimsToTerraform(struct?: DataOktaAuthServerClaimsClaims): any;
export declare class DataOktaAuthServerClaimsClaimsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaAuthServerClaimsClaims | undefined;
    set internalValue(value: DataOktaAuthServerClaimsClaims | undefined);
    get alwaysIncludeInToken(): cdktf.IResolvable;
    get claimType(): string;
    get id(): string;
    get name(): string;
    get scopes(): string[];
    get status(): string;
    get value(): string;
    get valueType(): string;
}
export declare class DataOktaAuthServerClaimsClaimsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaAuthServerClaimsClaimsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims okta_auth_server_claims}
*/
export declare class DataOktaAuthServerClaims extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_auth_server_claims";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_claims okta_auth_server_claims} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAuthServerClaimsConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerClaimsConfig);
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    private _claims;
    get claims(): DataOktaAuthServerClaimsClaimsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
