import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAuthServerPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy#auth_server_id DataOktaAuthServerPolicy#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy#id DataOktaAuthServerPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the policy
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy#name DataOktaAuthServerPolicy#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy okta_auth_server_policy}
*/
export declare class DataOktaAuthServerPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_auth_server_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_policy okta_auth_server_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAuthServerPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerPolicyConfig);
    get assignedClients(): string[];
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get priority(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
