import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAuthServerScopesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Auth server ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes#auth_server_id DataOktaAuthServerScopes#auth_server_id}
    */
    readonly authServerId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes#id DataOktaAuthServerScopes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataOktaAuthServerScopesScopes {
}
export declare function dataOktaAuthServerScopesScopesToTerraform(struct?: DataOktaAuthServerScopesScopes): any;
export declare class DataOktaAuthServerScopesScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaAuthServerScopesScopes | undefined;
    set internalValue(value: DataOktaAuthServerScopesScopes | undefined);
    get consent(): string;
    get default(): cdktf.IResolvable;
    get description(): string;
    get displayName(): string;
    get id(): string;
    get metadataPublish(): string;
    get name(): string;
    get systemAttribute(): cdktf.IResolvable;
}
export declare class DataOktaAuthServerScopesScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaAuthServerScopesScopesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes okta_auth_server_scopes}
*/
export declare class DataOktaAuthServerScopes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_auth_server_scopes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server_scopes okta_auth_server_scopes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAuthServerScopesConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerScopesConfig);
    private _authServerId?;
    get authServerId(): string;
    set authServerId(value: string);
    get authServerIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _scopes;
    get scopes(): DataOktaAuthServerScopesScopesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
