import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaAuthServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server#id DataOktaAuthServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/auth_server#name DataOktaAuthServer#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/auth_server okta_auth_server}
*/
export declare class DataOktaAuthServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_auth_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/auth_server okta_auth_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaAuthServerConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaAuthServerConfig);
    get audiences(): string[];
    get credentialsLastRotated(): string;
    get credentialsNextRotation(): string;
    get credentialsRotationMode(): string;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuer(): string;
    get issuerMode(): string;
    get kid(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
