import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaBehaviorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behavior#id DataOktaBehavior#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behavior#name DataOktaBehavior#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/behavior okta_behavior}
*/
export declare class DataOktaBehavior extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_behavior";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/behavior okta_behavior} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaBehaviorConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaBehaviorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _settings;
    get settings(): cdktf.StringMap;
    get status(): string;
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
