import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaBehaviorsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behaviors#id DataOktaBehaviors#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Searches the name property of behaviors for matching value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/behaviors#q DataOktaBehaviors#q}
    */
    readonly q?: string;
}
export interface DataOktaBehaviorsBehaviors {
}
export declare function dataOktaBehaviorsBehaviorsToTerraform(struct?: DataOktaBehaviorsBehaviors): any;
export declare class DataOktaBehaviorsBehaviorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaBehaviorsBehaviors | undefined;
    set internalValue(value: DataOktaBehaviorsBehaviors | undefined);
    get id(): string;
    get name(): string;
    private _settings;
    get settings(): cdktf.StringMap;
    get status(): string;
    get type(): string;
}
export declare class DataOktaBehaviorsBehaviorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaBehaviorsBehaviorsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/behaviors okta_behaviors}
*/
export declare class DataOktaBehaviors extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_behaviors";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/behaviors okta_behaviors} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaBehaviorsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaBehaviorsConfig);
    private _behaviors;
    get behaviors(): DataOktaBehaviorsBehaviorsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
