import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaBrandConfig extends cdktf.TerraformMetaArguments {
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/brand#brand_id DataOktaBrand#brand_id}
    */
    readonly brandId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/brand okta_brand}
*/
export declare class DataOktaBrand extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_brand";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/brand okta_brand} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaBrandConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaBrandConfig);
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    get customPrivacyPolicyUrl(): string;
    get id(): string;
    get links(): string;
    get removePoweredByOkta(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
