import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaBrandsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/brands#id DataOktaBrands#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataOktaBrandsBrands {
}
export declare function dataOktaBrandsBrandsToTerraform(struct?: DataOktaBrandsBrands): any;
export declare class DataOktaBrandsBrandsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaBrandsBrands | undefined;
    set internalValue(value: DataOktaBrandsBrands | undefined);
    get customPrivacyPolicyUrl(): string;
    get id(): string;
    get links(): string;
    get removePoweredByOkta(): cdktf.IResolvable;
}
export declare class DataOktaBrandsBrandsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaBrandsBrandsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/brands okta_brands}
*/
export declare class DataOktaBrands extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_brands";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/brands okta_brands} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaBrandsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaBrandsConfig);
    private _brands;
    get brands(): DataOktaBrandsBrandsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
