import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaDefaultPoliciesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/default_policies#id DataOktaDefaultPolicies#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Policy type: OKTA_SIGN_ON, PASSWORD, MFA_ENROLL, or IDP_DISCOVERY
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/default_policies#type DataOktaDefaultPolicies#type}
    */
    readonly type: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/default_policies okta_default_policies}
*/
export declare class DataOktaDefaultPolicies extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_default_policies";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/default_policies okta_default_policies} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaDefaultPoliciesConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaDefaultPoliciesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
