import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaEmailCustomizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_customization#brand_id DataOktaEmailCustomization#brand_id}
    */
    readonly brandId: string;
    /**
    * The ID of the customization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_customization#customization_id DataOktaEmailCustomization#customization_id}
    */
    readonly customizationId: string;
    /**
    * Template Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_customization#template_name DataOktaEmailCustomization#template_name}
    */
    readonly templateName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_customization okta_email_customization}
*/
export declare class DataOktaEmailCustomization extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_email_customization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/email_customization okta_email_customization} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaEmailCustomizationConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaEmailCustomizationConfig);
    get body(): string;
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    private _customizationId?;
    get customizationId(): string;
    set customizationId(value: string);
    get customizationIdInput(): string | undefined;
    get id(): string;
    get isDefault(): cdktf.IResolvable;
    get language(): string;
    get links(): string;
    get subject(): string;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    get templateNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
