import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaEmailCustomizationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_customizations#brand_id DataOktaEmailCustomizations#brand_id}
    */
    readonly brandId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_customizations#id DataOktaEmailCustomizations#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Template Name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_customizations#template_name DataOktaEmailCustomizations#template_name}
    */
    readonly templateName: string;
}
export interface DataOktaEmailCustomizationsEmailCustomizations {
}
export declare function dataOktaEmailCustomizationsEmailCustomizationsToTerraform(struct?: DataOktaEmailCustomizationsEmailCustomizations): any;
export declare class DataOktaEmailCustomizationsEmailCustomizationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaEmailCustomizationsEmailCustomizations | undefined;
    set internalValue(value: DataOktaEmailCustomizationsEmailCustomizations | undefined);
    get body(): string;
    get id(): string;
    get isDefault(): cdktf.IResolvable;
    get language(): string;
    get links(): string;
    get subject(): string;
}
export declare class DataOktaEmailCustomizationsEmailCustomizationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaEmailCustomizationsEmailCustomizationsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_customizations okta_email_customizations}
*/
export declare class DataOktaEmailCustomizations extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_email_customizations";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/email_customizations okta_email_customizations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaEmailCustomizationsConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaEmailCustomizationsConfig);
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    private _emailCustomizations;
    get emailCustomizations(): DataOktaEmailCustomizationsEmailCustomizationsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    get templateNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
