import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaEmailTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_template#brand_id DataOktaEmailTemplate#brand_id}
    */
    readonly brandId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_template#id DataOktaEmailTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the email template
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/email_template#name DataOktaEmailTemplate#name}
    */
    readonly name: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/email_template okta_email_template}
*/
export declare class DataOktaEmailTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_email_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/email_template okta_email_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaEmailTemplateConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaEmailTemplateConfig);
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get links(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
