import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Force delay of the group read by N seconds. Useful when eventual consistency of group information needs to be allowed for; for instance, when group rules are known to have been applied.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group#delay_read_seconds DataOktaGroup#delay_read_seconds}
    */
    readonly delayReadSeconds?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group#id DataOktaGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Fetch group users, having default off cuts down on API calls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group#include_users DataOktaGroup#include_users}
    */
    readonly includeUsers?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group#name DataOktaGroup#name}
    */
    readonly name?: string;
    /**
    * Type of the group. When specified in the terraform resource, will act as a filter when searching for the group
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/group#type DataOktaGroup#type}
    */
    readonly type?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/group okta_group}
*/
export declare class DataOktaGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/group okta_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaGroupConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaGroupConfig);
    private _delayReadSeconds?;
    get delayReadSeconds(): string;
    set delayReadSeconds(value: string);
    resetDelayReadSeconds(): void;
    get delayReadSecondsInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeUsers?;
    get includeUsers(): boolean | cdktf.IResolvable;
    set includeUsers(value: boolean | cdktf.IResolvable);
    resetIncludeUsers(): void;
    get includeUsersInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get users(): string[];
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
