import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups#id DataOktaGroups#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Searches the name property of groups for matching value
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups#q DataOktaGroups#q}
    */
    readonly q?: string;
    /**
    * Searches for groups with a supported filtering expression for all attributes except for '_embedded', '_links', and 'objectClass'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups#search DataOktaGroups#search}
    */
    readonly search?: string;
    /**
    * Type of the group. When specified in the terraform resource, will act as a filter when searching for the groups
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/groups#type DataOktaGroups#type}
    */
    readonly type?: string;
}
export interface DataOktaGroupsGroups {
}
export declare function dataOktaGroupsGroupsToTerraform(struct?: DataOktaGroupsGroups): any;
export declare class DataOktaGroupsGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaGroupsGroups | undefined;
    set internalValue(value: DataOktaGroupsGroups | undefined);
    get customProfileAttributes(): string;
    get description(): string;
    get id(): string;
    get name(): string;
    get type(): string;
}
export declare class DataOktaGroupsGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaGroupsGroupsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/groups okta_groups}
*/
export declare class DataOktaGroups extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_groups";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/groups okta_groups} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaGroupsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaGroupsConfig);
    private _groups;
    get groups(): DataOktaGroupsGroupsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _q?;
    get q(): string;
    set q(value: string);
    resetQ(): void;
    get qInput(): string | undefined;
    private _search?;
    get search(): string;
    set search(value: string);
    resetSearch(): void;
    get searchInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
