import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaIdpMetadataSamlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml#id DataOktaIdpMetadataSaml#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml#idp_id DataOktaIdpMetadataSaml#idp_id}
    */
    readonly idpId?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml okta_idp_metadata_saml}
*/
export declare class DataOktaIdpMetadataSaml extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_idp_metadata_saml";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_metadata_saml okta_idp_metadata_saml} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaIdpMetadataSamlConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaIdpMetadataSamlConfig);
    get assertionsSigned(): cdktf.IResolvable;
    get authnRequestSigned(): cdktf.IResolvable;
    get encryptionCertificate(): string;
    get entityId(): string;
    get httpPostBinding(): string;
    get httpRedirectBinding(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _idpId?;
    get idpId(): string;
    set idpId(value: string);
    resetIdpId(): void;
    get idpIdInput(): string | undefined;
    get metadata(): string;
    get signingCertificate(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
