import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaIdpOidcConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc#id DataOktaIdpOidc#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc#name DataOktaIdpOidc#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc okta_idp_oidc}
*/
export declare class DataOktaIdpOidc extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_idp_oidc";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_oidc okta_idp_oidc} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaIdpOidcConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaIdpOidcConfig);
    get authorizationBinding(): string;
    get authorizationUrl(): string;
    get clientId(): string;
    get clientSecret(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuerMode(): string;
    get issuerUrl(): string;
    get jwksBinding(): string;
    get jwksUrl(): string;
    get maxClockSkew(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get protocolType(): string;
    get scopes(): string[];
    get tokenBinding(): string;
    get tokenUrl(): string;
    get type(): string;
    get userInfoBinding(): string;
    get userInfoUrl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
