import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaIdpSamlConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_saml#id DataOktaIdpSaml#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_saml#name DataOktaIdpSaml#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_saml okta_idp_saml}
*/
export declare class DataOktaIdpSaml extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_idp_saml";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_saml okta_idp_saml} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaIdpSamlConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaIdpSamlConfig);
    get acsBinding(): string;
    get acsType(): string;
    get audience(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuer(): string;
    get issuerMode(): string;
    get kid(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get ssoBinding(): string;
    get ssoDestination(): string;
    get ssoUrl(): string;
    get subjectFilter(): string;
    get subjectFormat(): string[];
    get type(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
