import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaIdpSocialConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_social#id DataOktaIdpSocial#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * name of the IdP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/idp_social#name DataOktaIdpSocial#name}
    */
    readonly name?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/idp_social okta_idp_social}
*/
export declare class DataOktaIdpSocial extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_idp_social";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/idp_social okta_idp_social} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaIdpSocialConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaIdpSocialConfig);
    get accountLinkAction(): string;
    get accountLinkGroupInclude(): string[];
    get authorizationBinding(): string;
    get authorizationUrl(): string;
    get clientId(): string;
    get clientSecret(): string;
    get deprovisionedAction(): string;
    get groupsAction(): string;
    get groupsAssignment(): string[];
    get groupsAttribute(): string;
    get groupsFilter(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuerMode(): string;
    get maxClockSkew(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get profileMaster(): cdktf.IResolvable;
    get protocolType(): string;
    get provisioningAction(): string;
    get scopes(): string[];
    get status(): string;
    get subjectMatchAttribute(): string;
    get subjectMatchType(): string;
    get suspendedAction(): string;
    get tokenBinding(): string;
    get tokenUrl(): string;
    get type(): string;
    get usernameTemplate(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
