import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaRoleSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/role_subscription#id DataOktaRoleSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Type of the notification
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/role_subscription#notification_type DataOktaRoleSubscription#notification_type}
    */
    readonly notificationType: string;
    /**
    * Type of the role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/role_subscription#role_type DataOktaRoleSubscription#role_type}
    */
    readonly roleType: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/role_subscription okta_role_subscription}
*/
export declare class DataOktaRoleSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_role_subscription";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/role_subscription okta_role_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaRoleSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaRoleSubscriptionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _notificationType?;
    get notificationType(): string;
    set notificationType(value: string);
    get notificationTypeInput(): string | undefined;
    private _roleType?;
    get roleType(): string;
    set roleType(value: string);
    get roleTypeInput(): string | undefined;
    get status(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
