import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaThemeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/theme#brand_id DataOktaTheme#brand_id}
    */
    readonly brandId: string;
    /**
    * Theme ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/theme#theme_id DataOktaTheme#theme_id}
    */
    readonly themeId: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/theme okta_theme}
*/
export declare class DataOktaTheme extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_theme";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/theme okta_theme} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaThemeConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaThemeConfig);
    get backgroundImageUrl(): string;
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    get emailTemplateTouchPointVariant(): string;
    get endUserDashboardTouchPointVariant(): string;
    get errorPageTouchPointVariant(): string;
    get faviconUrl(): string;
    get id(): string;
    get links(): string;
    get logoUrl(): string;
    get primaryColorContrastHex(): string;
    get primaryColorHex(): string;
    get secondaryColorContrastHex(): string;
    get secondaryColorHex(): string;
    get signInPageTouchPointVariant(): string;
    private _themeId?;
    get themeId(): string;
    set themeId(value: string);
    get themeIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
