import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaThemesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Brand ID
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/themes#brand_id DataOktaThemes#brand_id}
    */
    readonly brandId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/themes#id DataOktaThemes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataOktaThemesThemes {
}
export declare function dataOktaThemesThemesToTerraform(struct?: DataOktaThemesThemes): any;
export declare class DataOktaThemesThemesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaThemesThemes | undefined;
    set internalValue(value: DataOktaThemesThemes | undefined);
    get backgroundImageUrl(): string;
    get emailTemplateTouchPointVariant(): string;
    get endUserDashboardTouchPointVariant(): string;
    get errorPageTouchPointVariant(): string;
    get faviconUrl(): string;
    get id(): string;
    get links(): string;
    get logoUrl(): string;
    get primaryColorContrastHex(): string;
    get primaryColorHex(): string;
    get secondaryColorContrastHex(): string;
    get secondaryColorHex(): string;
    get signInPageTouchPointVariant(): string;
}
export declare class DataOktaThemesThemesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaThemesThemesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/themes okta_themes}
*/
export declare class DataOktaThemes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_themes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/themes okta_themes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaThemesConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaThemesConfig);
    private _brandId?;
    get brandId(): string;
    set brandId(value: string);
    get brandIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _themes;
    get themes(): DataOktaThemesThemesList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
