import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaTrustedOriginsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Filter criteria. Filter value will be URL-encoded by the provider
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins#filter DataOktaTrustedOrigins#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins#id DataOktaTrustedOrigins#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
export interface DataOktaTrustedOriginsTrustedOrigins {
}
export declare function dataOktaTrustedOriginsTrustedOriginsToTerraform(struct?: DataOktaTrustedOriginsTrustedOrigins): any;
export declare class DataOktaTrustedOriginsTrustedOriginsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaTrustedOriginsTrustedOrigins | undefined;
    set internalValue(value: DataOktaTrustedOriginsTrustedOrigins | undefined);
    get active(): cdktf.IResolvable;
    get id(): string;
    get name(): string;
    get origin(): string;
    get scopes(): string[];
}
export declare class DataOktaTrustedOriginsTrustedOriginsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaTrustedOriginsTrustedOriginsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins okta_trusted_origins}
*/
export declare class DataOktaTrustedOrigins extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_trusted_origins";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/trusted_origins okta_trusted_origins} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaTrustedOriginsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataOktaTrustedOriginsConfig);
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _trustedOrigins;
    get trustedOrigins(): DataOktaTrustedOriginsTrustedOriginsList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
