import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataOktaUserSecurityQuestionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions#id DataOktaUserSecurityQuestions#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of a Okta User
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions#user_id DataOktaUserSecurityQuestions#user_id}
    */
    readonly userId: string;
}
export interface DataOktaUserSecurityQuestionsQuestions {
}
export declare function dataOktaUserSecurityQuestionsQuestionsToTerraform(struct?: DataOktaUserSecurityQuestionsQuestions): any;
export declare class DataOktaUserSecurityQuestionsQuestionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataOktaUserSecurityQuestionsQuestions | undefined;
    set internalValue(value: DataOktaUserSecurityQuestionsQuestions | undefined);
    get key(): string;
    get text(): string;
}
export declare class DataOktaUserSecurityQuestionsQuestionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataOktaUserSecurityQuestionsQuestionsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions okta_user_security_questions}
*/
export declare class DataOktaUserSecurityQuestions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "okta_user_security_questions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/okta/d/user_security_questions okta_user_security_questions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataOktaUserSecurityQuestionsConfig
    */
    constructor(scope: Construct, id: string, config: DataOktaUserSecurityQuestionsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _questions;
    get questions(): DataOktaUserSecurityQuestionsQuestionsList;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    get userIdInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
